/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector;

import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.connector.BootstrapContextImpl;
import org.apache.geronimo.connector.work.GeronimoWorkManager;

public class ResourceAdapterWrapper
implements ResourceAdapter {
    private final String resourceAdapterClass;
    private final BootstrapContext bootstrapContext;
    protected final ResourceAdapter resourceAdapter;

    public ResourceAdapterWrapper() {
        this.resourceAdapterClass = null;
        this.bootstrapContext = null;
        this.resourceAdapter = null;
    }

    public ResourceAdapterWrapper(String resourceAdapterClass, GeronimoWorkManager workManager, ClassLoader cl) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.resourceAdapterClass = resourceAdapterClass;
        this.bootstrapContext = new BootstrapContextImpl(workManager);
        Class<?> clazz = cl.loadClass(resourceAdapterClass);
        this.resourceAdapter = (ResourceAdapter)clazz.newInstance();
    }

    public ResourceAdapterWrapper(ResourceAdapter resourceAdapter, GeronimoWorkManager workManager) {
        this.resourceAdapterClass = resourceAdapter.getClass().getName();
        this.bootstrapContext = new BootstrapContextImpl(workManager);
        this.resourceAdapter = resourceAdapter;
    }

    public String getResourceAdapterClass() {
        return this.resourceAdapterClass;
    }

    public void registerResourceAdapterAssociation(ResourceAdapterAssociation resourceAdapterAssociation) throws ResourceException {
        resourceAdapterAssociation.setResourceAdapter(this.resourceAdapter);
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        throw new IllegalStateException("Don't call this");
    }

    public void stop() {
        throw new IllegalStateException("Don't call this");
    }

    public void endpointActivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws ResourceException {
        this.resourceAdapter.endpointActivation(messageEndpointFactory, activationSpec);
    }

    public void endpointDeactivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) {
        this.resourceAdapter.endpointDeactivation(messageEndpointFactory, activationSpec);
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        return this.resourceAdapter.getXAResources(specs);
    }

    public void doStart() throws Exception {
        this.resourceAdapter.start(this.bootstrapContext);
    }

    public void doStop() {
        this.resourceAdapter.stop();
    }

    public void doFail() {
        this.resourceAdapter.stop();
    }
}

