/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.PoolIdleReleaserTimer;
import org.apache.geronimo.connector.outbound.PoolingAttributes;
import org.apache.geronimo.connector.outbound.SinglePoolConnectionInterceptor;

public abstract class AbstractSinglePoolConnectionInterceptor
implements ConnectionInterceptor,
PoolingAttributes {
    protected static Log log = LogFactory.getLog((String)SinglePoolConnectionInterceptor.class.getName());
    protected final ConnectionInterceptor next;
    private final ReadWriteLock resizeLock = new WriterPreferenceReadWriteLock();
    protected FIFOSemaphore permits;
    protected int blockingTimeoutMilliseconds;
    protected int connectionCount = 0;
    private long idleTimeoutMilliseconds;
    private IdleReleaser idleReleaser;
    protected Timer timer = PoolIdleReleaserTimer.getTimer();
    protected int minSize = 0;
    protected int shrinkLater = 0;

    public AbstractSinglePoolConnectionInterceptor(ConnectionInterceptor next, int maxSize, int minSize, int blockingTimeoutMilliseconds, int idleTimeoutMinutes) {
        this.next = next;
        this.minSize = minSize;
        this.blockingTimeoutMilliseconds = blockingTimeoutMilliseconds;
        this.setIdleTimeoutMinutes(idleTimeoutMinutes);
        this.permits = new FIFOSemaphore((long)maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        block7: {
            if (connectionInfo.getManagedConnectionInfo().getManagedConnection() != null) {
                return;
            }
            try {
                this.resizeLock.readLock().acquire();
                try {
                    if (this.permits.attempt((long)this.blockingTimeoutMilliseconds)) {
                        this.internalGetConnection(connectionInfo);
                        break block7;
                    }
                    throw new ResourceException("No ManagedConnections available within configured blocking timeout ( " + this.blockingTimeoutMilliseconds + " [ms] )");
                }
                finally {
                    this.resizeLock.readLock().release();
                }
            }
            catch (InterruptedException ie) {
                throw new ResourceException("Interrupted while requesting permit!");
            }
        }
    }

    protected abstract void internalGetConnection(ConnectionInfo var1) throws ResourceException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("returning connection" + connectionInfo.getConnectionHandle()));
        }
        try {
            this.resizeLock.readLock().acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted before returning connection! Pool is now in an invalid state!");
        }
        try {
            ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
            if (connectionReturnAction == ConnectionReturnAction.RETURN_HANDLE && mci.hasConnectionHandles()) {
                return;
            }
            boolean wasInPool = this.internalReturn(connectionInfo, connectionReturnAction);
            if (!wasInPool) {
                this.permits.release();
            }
        }
        finally {
            this.resizeLock.readLock().release();
        }
    }

    protected abstract boolean internalReturn(ConnectionInfo var1, ConnectionReturnAction var2);

    public int getPartitionCount() {
        return 1;
    }

    public abstract int getPartitionMaxSize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPartitionMaxSize(int maxSize) throws InterruptedException {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("Max size must be positive, not " + maxSize);
        }
        if (maxSize != this.getPartitionMaxSize()) {
            this.resizeLock.writeLock().acquire();
            try {
                int shrinkNow;
                int checkedOut = (int)this.permits.permits();
                this.shrinkLater = checkedOut - maxSize;
                if (this.shrinkLater < 0) {
                    this.shrinkLater = 0;
                }
                if ((shrinkNow = checkedOut + this.connectionCount - maxSize - this.shrinkLater) < 0) {
                    shrinkNow = 0;
                }
                this.permits = new FIFOSemaphore((long)maxSize);
                for (int i = 0; i < checkedOut - this.shrinkLater; ++i) {
                    this.permits.acquire();
                }
                this.transferConnections(maxSize, shrinkNow);
            }
            finally {
                this.resizeLock.writeLock().release();
            }
        }
    }

    protected abstract void transferConnections(int var1, int var2);

    public abstract int getIdleConnectionCount();

    public int getConnectionCount() {
        return this.connectionCount;
    }

    public int getPartitionMinSize() {
        return this.minSize;
    }

    public void setPartitionMinSize(int minSize) {
        this.minSize = minSize;
    }

    public int getBlockingTimeoutMilliseconds() {
        return this.blockingTimeoutMilliseconds;
    }

    public void setBlockingTimeoutMilliseconds(int blockingTimeoutMilliseconds) {
        if (blockingTimeoutMilliseconds < 0) {
            throw new IllegalArgumentException("blockingTimeoutMilliseconds must be positive or 0, not " + blockingTimeoutMilliseconds);
        }
        this.blockingTimeoutMilliseconds = blockingTimeoutMilliseconds == 0 ? Integer.MAX_VALUE : blockingTimeoutMilliseconds;
    }

    public int getIdleTimeoutMinutes() {
        return (int)this.idleTimeoutMilliseconds / 60000;
    }

    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
        if (idleTimeoutMinutes < 0) {
            throw new IllegalArgumentException("idleTimeoutMinutes must be positive or 0, not " + idleTimeoutMinutes);
        }
        if (this.idleReleaser != null) {
            this.idleReleaser.cancel();
        }
        if (idleTimeoutMinutes > 0) {
            this.idleTimeoutMilliseconds = idleTimeoutMinutes * 60 * 1000;
            this.idleReleaser = new IdleReleaser();
            this.timer.schedule((TimerTask)this.idleReleaser, this.idleTimeoutMilliseconds, this.idleTimeoutMilliseconds);
        }
    }

    protected abstract void getExpiredManagedConnectionInfos(long var1, ArrayList var3);

    protected abstract boolean addToPool(ManagedConnectionInfo var1);

    protected class FillTask
    extends TimerTask {
        private final ManagedConnectionFactory managedConnectionFactory;
        private final Subject subject;
        private final ConnectionRequestInfo cri;

        public FillTask(ConnectionInfo connectionInfo) {
            this.managedConnectionFactory = connectionInfo.getManagedConnectionInfo().getManagedConnectionFactory();
            this.subject = connectionInfo.getManagedConnectionInfo().getSubject();
            this.cri = connectionInfo.getManagedConnectionInfo().getConnectionRequestInfo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                AbstractSinglePoolConnectionInterceptor.this.resizeLock.readLock().acquire();
            }
            catch (InterruptedException e) {
                return;
            }
            try {
                while (AbstractSinglePoolConnectionInterceptor.this.connectionCount < AbstractSinglePoolConnectionInterceptor.this.minSize) {
                    ManagedConnectionInfo mci = new ManagedConnectionInfo(this.managedConnectionFactory, this.cri);
                    mci.setSubject(this.subject);
                    ConnectionInfo ci = new ConnectionInfo(mci);
                    try {
                        AbstractSinglePoolConnectionInterceptor.this.next.getConnection(ci);
                    }
                    catch (ResourceException e) {
                        AbstractSinglePoolConnectionInterceptor.this.resizeLock.readLock().release();
                        return;
                    }
                    boolean added = false;
                    added = AbstractSinglePoolConnectionInterceptor.this.addToPool(mci);
                    if (added) continue;
                    AbstractSinglePoolConnectionInterceptor.this.internalReturn(ci, ConnectionReturnAction.DESTROY);
                    return;
                }
            }
            finally {
                AbstractSinglePoolConnectionInterceptor.this.resizeLock.readLock().release();
            }
        }
    }

    private class IdleReleaser
    extends TimerTask {
        private IdleReleaser() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                AbstractSinglePoolConnectionInterceptor.this.resizeLock.readLock().acquire();
            }
            catch (InterruptedException e) {
                return;
            }
            try {
                long threshold = System.currentTimeMillis() - AbstractSinglePoolConnectionInterceptor.this.idleTimeoutMilliseconds;
                ArrayList killList = new ArrayList(AbstractSinglePoolConnectionInterceptor.this.getPartitionMaxSize());
                AbstractSinglePoolConnectionInterceptor.this.getExpiredManagedConnectionInfos(threshold, killList);
                Iterator i = killList.iterator();
                while (i.hasNext()) {
                    ManagedConnectionInfo managedConnectionInfo = (ManagedConnectionInfo)i.next();
                    ConnectionInfo killInfo = new ConnectionInfo(managedConnectionInfo);
                    AbstractSinglePoolConnectionInterceptor.this.internalReturn(killInfo, ConnectionReturnAction.DESTROY);
                }
                AbstractSinglePoolConnectionInterceptor.this.permits.release((long)killList.size());
            }
            finally {
                AbstractSinglePoolConnectionInterceptor.this.resizeLock.readLock().release();
            }
        }
    }
}

