/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;

public class GeronimoConnectionEventListener
implements ConnectionEventListener {
    private static Log log;
    private final ManagedConnectionInfo managedConnectionInfo;
    private final ConnectionInterceptor stack;
    private final List connectionInfos = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public GeronimoConnectionEventListener(ConnectionInterceptor stack, ManagedConnectionInfo managedConnectionInfo) {
        this.stack = stack;
        this.managedConnectionInfo = managedConnectionInfo;
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        if (connectionEvent.getSource() != this.managedConnectionInfo.getManagedConnection()) {
            throw new IllegalArgumentException("ConnectionClosed event received from wrong ManagedConnection. Expected " + this.managedConnectionInfo.getManagedConnection() + ", actual " + connectionEvent.getSource());
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("connectionClosed called with " + connectionEvent.getConnectionHandle()));
        }
        ConnectionInfo ci = new ConnectionInfo(this.managedConnectionInfo);
        ci.setConnectionHandle(connectionEvent.getConnectionHandle());
        this.stack.returnConnection(ci, ConnectionReturnAction.RETURN_HANDLE);
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        if (connectionEvent.getSource() != this.managedConnectionInfo.getManagedConnection()) {
            throw new IllegalArgumentException("ConnectionError event received from wrong ManagedConnection. Expected " + this.managedConnectionInfo.getManagedConnection() + ", actual " + connectionEvent.getSource());
        }
        log.info((Object)("connectionErrorOccurred called with " + connectionEvent.getConnectionHandle()), (Throwable)connectionEvent.getException());
        ConnectionInfo ci = new ConnectionInfo(this.managedConnectionInfo);
        ci.setConnectionHandle(connectionEvent.getConnectionHandle());
        this.stack.returnConnection(ci, ConnectionReturnAction.DESTROY);
    }

    public void localTransactionStarted(ConnectionEvent event) {
    }

    public void localTransactionCommitted(ConnectionEvent event) {
    }

    public void localTransactionRolledback(ConnectionEvent event) {
    }

    public void addConnectionInfo(ConnectionInfo connectionInfo) {
        if (!$assertionsDisabled && connectionInfo.getConnectionHandle() == null) {
            throw new AssertionError();
        }
        this.connectionInfos.add(connectionInfo);
    }

    public void removeConnectionInfo(ConnectionInfo connectionInfo) {
        if (!$assertionsDisabled && connectionInfo.getConnectionHandle() == null) {
            throw new AssertionError();
        }
        this.connectionInfos.remove(connectionInfo);
    }

    public boolean hasConnectionInfos() {
        return !this.connectionInfos.isEmpty();
    }

    public void clearConnectionInfos() {
        this.connectionInfos.clear();
    }

    public boolean hasConnectionInfo(ConnectionInfo connectionInfo) {
        return this.connectionInfos.contains(connectionInfo);
    }

    public boolean isFirstConnectionInfo(ConnectionInfo connectionInfo) {
        return !this.connectionInfos.isEmpty() && this.connectionInfos.get(0) == connectionInfo;
    }

    public Collection getConnectionInfos() {
        return Collections.unmodifiableCollection(this.connectionInfos);
    }

    static {
        $assertionsDisabled = !GeronimoConnectionEventListener.class.desiredAssertionStatus();
        log = LogFactory.getLog((String)GeronimoConnectionEventListener.class.getName());
    }
}

