/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LazyAssociatableConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionManagerContainer;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.PoolingAttributes;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.transaction.manager.NamedXAResource;

public abstract class AbstractConnectionManager
implements ConnectionManagerContainer,
ConnectionManager,
LazyAssociatableConnectionManager,
PoolingAttributes {
    protected final Interceptors interceptors;

    public AbstractConnectionManager() {
        this.interceptors = null;
    }

    public AbstractConnectionManager(Interceptors interceptors) {
        this.interceptors = interceptors;
    }

    public Object createConnectionFactory(ManagedConnectionFactory mcf) throws ResourceException {
        return mcf.createConnectionFactory((ConnectionManager)this);
    }

    public Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        ManagedConnectionInfo mci = new ManagedConnectionInfo(managedConnectionFactory, connectionRequestInfo);
        ConnectionInfo ci = new ConnectionInfo(mci);
        this.getStack().getConnection(ci);
        return ci.getConnectionHandle();
    }

    public void associateConnection(Object connection, ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        ManagedConnectionInfo mci = new ManagedConnectionInfo(managedConnectionFactory, connectionRequestInfo);
        ConnectionInfo ci = new ConnectionInfo(mci);
        ci.setConnectionHandle(connection);
        this.getStack().getConnection(ci);
    }

    ConnectionInterceptor getConnectionInterceptor() {
        return this.getStack();
    }

    public ConnectionManagerContainer.ReturnableXAResource getRecoveryXAResource(ManagedConnectionFactory managedConnectionFactory) throws ResourceException {
        ManagedConnectionInfo mci = new ManagedConnectionInfo(managedConnectionFactory, null);
        NamedXAResource namedXAResource = (NamedXAResource)mci.getXAResource();
        if (namedXAResource == null) {
            return null;
        }
        ConnectionInfo recoveryConnectionInfo = new ConnectionInfo(mci);
        this.getRecoveryStack().getConnection(recoveryConnectionInfo);
        return new ConnectionManagerContainer.ReturnableXAResource(namedXAResource, this.getRecoveryStack(), recoveryConnectionInfo);
    }

    public int getPartitionCount() {
        return this.getPooling().getPartitionCount();
    }

    public int getPartitionMaxSize() {
        return this.getPooling().getPartitionMaxSize();
    }

    public void setPartitionMaxSize(int maxSize) throws InterruptedException {
        this.getPooling().setPartitionMaxSize(maxSize);
    }

    public int getPartitionMinSize() {
        return this.getPooling().getPartitionMinSize();
    }

    public void setPartitionMinSize(int minSize) {
        this.getPooling().setPartitionMinSize(minSize);
    }

    public int getIdleConnectionCount() {
        return this.getPooling().getIdleConnectionCount();
    }

    public int getConnectionCount() {
        return this.getPooling().getConnectionCount();
    }

    public int getBlockingTimeoutMilliseconds() {
        return this.getPooling().getBlockingTimeoutMilliseconds();
    }

    public void setBlockingTimeoutMilliseconds(int timeoutMilliseconds) {
        this.getPooling().setBlockingTimeoutMilliseconds(timeoutMilliseconds);
    }

    public int getIdleTimeoutMinutes() {
        return this.getPooling().getIdleTimeoutMinutes();
    }

    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
        this.getPooling().setIdleTimeoutMinutes(idleTimeoutMinutes);
    }

    private ConnectionInterceptor getStack() {
        return this.interceptors.getStack();
    }

    private ConnectionInterceptor getRecoveryStack() {
        return this.interceptors.getRecoveryStack();
    }

    public PoolingSupport getPooling() {
        return this.interceptors.getPoolingAttributes();
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
        this.interceptors.getStack().destroy();
    }

    public void doFail() {
        this.interceptors.getStack().destroy();
    }

    public static interface Interceptors {
        public ConnectionInterceptor getStack();

        public ConnectionInterceptor getRecoveryStack();

        public PoolingSupport getPoolingAttributes();
    }
}

