/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.configmanager;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.geronimo.console.BasePortlet;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.kernel.config.ConfigurationInfo;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.config.NoSuchStoreException;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.kernel.management.State;

public class ConfigManagerPortlet
extends BasePortlet {
    private static final String START_ACTION = "start";
    private static final String STOP_ACTION = "stop";
    private static final String UNINSTALL_ACTION = "uninstall";
    private static final String CONTAINSCONFIG_METHOD = "containsConfiguration";
    private static final String UNINSTALL_METHOD = "uninstall";
    private static final String[] CONTAINSCONFIG_SIG = new String[]{URI.class.getName()};
    private static final String[] UNINSTALL_SIG = new String[]{URI.class.getName()};
    private static final String QUEUETOPIC_URI = "runtimedestination/";
    private static final String CONFIG_INIT_PARAM = "config-type";
    private static final ObjectName deployer = JMXUtil.getObjectName((String)"geronimo.server:J2EEApplication=null,J2EEModule=org/apache/geronimo/RuntimeDeployer,J2EEServer=geronimo,j2eeType=Deployer,name=Deployer");
    private String messageInstalled = "";
    private String messageStatus = "";
    private Kernel kernel;
    private PortletRequestDispatcher normalView;
    private PortletRequestDispatcher maximizedView;
    private PortletRequestDispatcher helpView;
    private static final Collection EXCLUDED = new ArrayList();

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        block7: {
            String action = actionRequest.getParameter("action");
            actionResponse.setRenderParameter("message", "");
            try {
                ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
                ObjectName configName = null;
                String config = this.getConfigID(actionRequest);
                configName = configurationManager.isLoaded(URI.create(config)) ? JMXUtil.getObjectName((String)("geronimo.config:name=\"" + this.getConfigID(actionRequest) + "\"")) : configurationManager.load(URI.create(config));
                if (START_ACTION.equals(action)) {
                    this.kernel.startRecursiveGBean(configName);
                    this.messageStatus = "Started application<br /><br />";
                    break block7;
                }
                if (STOP_ACTION.equals(action)) {
                    this.kernel.stopGBean(configName);
                    this.messageStatus = "Stopped application<br /><br />";
                    break block7;
                }
                if ("uninstall".equals(action)) {
                    this.uninstallConfig(actionRequest);
                    this.messageStatus = "Uninstalled application<br /><br />";
                    break block7;
                }
                this.messageStatus = "Invalid value for changeState: " + action + "<br /><br />";
                throw new PortletException("Invalid value for changeState: " + action);
            }
            catch (NoSuchConfigException e) {
                this.messageStatus = "Configuration not found<br /><br />";
                throw new PortletException("Configuration not found", (Throwable)e);
            }
            catch (InvalidConfigException e) {
                this.messageStatus = "Configuration not found<br /><br />";
                throw new PortletException("Configuration not found", (Throwable)e);
            }
            catch (Exception e) {
                this.messageStatus = "Encountered an unhandled exception<br /><br />";
                throw new PortletException("Exception", (Throwable)e);
            }
        }
    }

    private void uninstallConfig(ActionRequest actionRequest) throws PortletException, Exception {
        ConfigurationManager configManager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
        List configStores = configManager.listStores();
        int size = configStores.size();
        String configID = this.getConfigID(actionRequest);
        for (int i = 0; i < size; ++i) {
            int state;
            ObjectName configStore = (ObjectName)configStores.get(i);
            Boolean result = (Boolean)this.kernel.invoke(configStore, CONTAINSCONFIG_METHOD, new Object[]{URI.create(configID)}, CONTAINSCONFIG_SIG);
            if (!result.booleanValue()) continue;
            if (configManager.isLoaded(URI.create(configID)) && (state = this.kernel.getGBeanState(JMXUtil.getObjectName((String)("geronimo.config:name=\"" + configID + "\"")))) == State.RUNNING.toInt()) {
                this.kernel.stopGBean(JMXUtil.getObjectName((String)("geronimo.config:name=\"" + configID + "\"")));
            }
            this.kernel.invoke(configStore, "uninstall", new Object[]{URI.create(configID)}, UNINSTALL_SIG);
        }
    }

    private boolean shouldListConfig(ConfigurationInfo info) {
        String configType = this.getInitParameter(CONFIG_INIT_PARAM);
        return configType == null || info.getType().getName().equalsIgnoreCase(configType);
    }

    private String getConfigID(ActionRequest actionRequest) throws PortletException {
        return actionRequest.getParameter("configId");
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
            return;
        }
        ArrayList<ConfigurationInfo> configInfo = new ArrayList<ConfigurationInfo>();
        ConfigurationManager configManager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
        List stores = configManager.listStores();
        Iterator i = stores.iterator();
        while (i.hasNext()) {
            ObjectName storeName = (ObjectName)i.next();
            try {
                List infos = configManager.listConfigurations(storeName);
                Iterator j = infos.iterator();
                while (j.hasNext()) {
                    ConfigurationInfo info = (ConfigurationInfo)j.next();
                    if (!this.shouldListConfig(info) || info.getConfigID().getPath().startsWith(QUEUETOPIC_URI) || info.getConfigID().getPath().startsWith("runtimerealm/")) continue;
                    configInfo.add(info);
                }
            }
            catch (NoSuchStoreException e) {
            }
        }
        renderRequest.setAttribute("configurations", configInfo);
        this.messageInstalled = configInfo.size() == 0 ? "No modules found of this type<br /><br />" : "";
        renderRequest.setAttribute("messageInstalled", (Object)this.messageInstalled);
        renderRequest.setAttribute("messageStatus", (Object)this.messageStatus);
        this.messageStatus = "";
        if (WindowState.NORMAL.equals((Object)renderRequest.getWindowState())) {
            this.normalView.include(renderRequest, renderResponse);
        } else {
            this.maximizedView.include(renderRequest, renderResponse);
        }
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.helpView.include(renderRequest, renderResponse);
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.kernel = KernelRegistry.getSingleKernel();
        this.normalView = portletConfig.getPortletContext().getRequestDispatcher("/WEB-INF/view/configmanager/normal.jsp");
        this.maximizedView = portletConfig.getPortletContext().getRequestDispatcher("/WEB-INF/view/configmanager/maximized.jsp");
        this.helpView = portletConfig.getPortletContext().getRequestDispatcher("/WEB-INF/view/configmanager/help.jsp");
    }

    public void destroy() {
        this.normalView = null;
        this.maximizedView = null;
        this.kernel = null;
        super.destroy();
    }
}

