/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.configmanager;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.console.BasePortlet;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.jmx.JMXUtil;

public class DeploymentPortlet
extends BasePortlet {
    private final String LINE_SEP = System.getProperty("line.separator");
    private PortletRequestDispatcher deployView;
    private PortletRequestDispatcher helpView;
    private Kernel kernel;
    private static final String[] ARGS = new String[]{File.class.getName(), File.class.getName()};
    private static final ObjectName deployer = JMXUtil.getObjectName((String)"geronimo.server:J2EEApplication=null,J2EEModule=org/apache/geronimo/RuntimeDeployer,J2EEServer=geronimo,j2eeType=Deployer,name=Deployer");
    private boolean messageNotRendered = true;

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        this.messageNotRendered = true;
        if (!PortletFileUpload.isMultipartContent((ActionRequest)actionRequest)) {
            throw new PortletException("Expected file upload");
        }
        File rootDir = new File(System.getProperty("java.io.tmpdir"));
        PortletFileUpload uploader = new PortletFileUpload((FileItemFactory)new DiskFileItemFactory(10240, rootDir));
        File moduleFile = null;
        File planFile = null;
        String startApp = null;
        try {
            List items = uploader.parseRequest(actionRequest);
            Iterator i = items.iterator();
            while (i.hasNext()) {
                FileItem item = (FileItem)i.next();
                if (!item.isFormField()) {
                    File file;
                    String fieldName = item.getFieldName();
                    String name = item.getName().trim();
                    if (name.length() == 0) {
                        file = null;
                    } else {
                        int index = name.lastIndexOf(92);
                        if (index != -1) {
                            name = name.substring(index + 1);
                        }
                        file = new File(rootDir, name);
                    }
                    if ("module".equals(fieldName)) {
                        moduleFile = file;
                    } else if ("plan".equals(fieldName)) {
                        planFile = file;
                    }
                    if (file == null) continue;
                    try {
                        item.write(file);
                        continue;
                    }
                    catch (Exception e) {
                        throw new PortletException((Throwable)e);
                    }
                }
                if (!"startApp".equalsIgnoreCase(item.getFieldName())) continue;
                startApp = item.getString();
            }
        }
        catch (FileUploadException e) {
            throw new PortletException((Throwable)e);
        }
        try {
            List list = (List)this.kernel.invoke(deployer, "deploy", new Object[]{moduleFile, planFile}, ARGS);
            actionResponse.setRenderParameter("outcome", "The application was successfully deployed.<br/>");
            if (startApp != null && "YES".equalsIgnoreCase(startApp)) {
                ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    URI config = URI.create((String)list.get(i));
                    if (configurationManager.isLoaded(config)) {
                        configurationManager.unload(config);
                    }
                    ObjectName configName = configurationManager.load(config);
                    this.kernel.startRecursiveGBean(configName);
                }
            }
        }
        catch (DeploymentException e) {
            e.printStackTrace();
            StringBuffer buf = new StringBuffer(256);
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                this.append(buf, cause.getMessage());
                buf.append(this.LINE_SEP);
            }
            actionResponse.setRenderParameter("outcome", buf.toString());
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private void append(StringBuffer buf, String message) {
        for (int i = 0; i < message.length(); ++i) {
            char ch = message.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
                continue;
            }
            if (ch == '>') {
                buf.append("&gt;");
                continue;
            }
            buf.append(ch);
        }
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        if (this.messageNotRendered) {
            renderRequest.setAttribute("outcome", (Object)renderRequest.getParameter("outcome"));
            this.messageNotRendered = false;
        }
        this.deployView.include(renderRequest, renderResponse);
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.helpView.include(renderRequest, renderResponse);
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.kernel = KernelRegistry.getSingleKernel();
        this.deployView = portletConfig.getPortletContext().getRequestDispatcher("/WEB-INF/view/configmanager/deploy.jsp");
        this.helpView = portletConfig.getPortletContext().getRequestDispatcher("/WEB-INF/view/configmanager/deployHelp.jsp");
    }

    public void destroy() {
        this.deployView = null;
        this.helpView = null;
        this.kernel = null;
        super.destroy();
    }
}

