/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.databasemanager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.geronimo.console.BasePortlet;
import org.apache.geronimo.console.databasemanager.DataSourceInfo;
import org.apache.geronimo.console.databasemanager.DatabaseManagerHelper;
import org.apache.geronimo.console.databasemanager.DetailViewRenderer;
import org.apache.geronimo.console.databasemanager.connectionmanager.ConnectionManagerRenderer;
import org.apache.geronimo.console.databasemanager.generic.ConnectorRenderer;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;

public abstract class AbstractConnectionFactoryManagerPortlet
extends BasePortlet {
    private static final DatabaseManagerHelper helper = new DatabaseManagerHelper();
    private static final String PARENT_ID = "org/apache/geronimo/SystemDatabase";
    private static final String ADDDS_MODE = "addDS";
    private static final String SUBMIT_CREATE = "Create";
    private static final String DATASOURCE_MSSQL = "MSSQLDataSource2";
    protected static final Map RENDERERS = new HashMap();
    private final ObjectName DATABASE_QUERY;
    protected final String NORMAL_VIEW;
    protected final String HELP_VIEW;
    protected final String ADDDS_VIEW = "/WEB-INF/view/databasemanager/addDS.jsp";
    protected final Class connectionFactoryClass;
    protected Kernel kernel;
    private PortletRequestDispatcher normalView;
    private PortletRequestDispatcher helpView;
    private PortletRequestDispatcher addDSView;
    private ConnectorRenderer connectorRenderer;
    private ConnectionManagerRenderer connectionManagerRenderer;

    public AbstractConnectionFactoryManagerPortlet(ObjectName ConnectionFactoryQuery, String NORMAL_VIEW, String HELP_VIEW, Class connectionFactoryClass) {
        this.DATABASE_QUERY = ConnectionFactoryQuery;
        this.NORMAL_VIEW = NORMAL_VIEW;
        this.HELP_VIEW = HELP_VIEW;
        this.connectionFactoryClass = connectionFactoryClass;
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String mode = actionRequest.getParameter("mode");
        String submit = actionRequest.getParameter("submit");
        if (mode == null) {
            return;
        }
        if (ADDDS_MODE.equals(mode)) {
            actionResponse.setRenderParameter("mode", mode);
            if (SUBMIT_CREATE.equals(submit)) {
                String dsName = actionRequest.getParameter("dsName");
                String jndiName = actionRequest.getParameter("jndiName");
                String dependency = actionRequest.getParameter("dependency");
                String driverClass = actionRequest.getParameter("driverClass");
                String jdbcUrl = actionRequest.getParameter("jdbcUrl");
                String dbUser = actionRequest.getParameter("dbUser");
                String dbPassword = actionRequest.getParameter("dbPassword");
                String dbProperties = actionRequest.getParameter("dbProperties");
                String poolMaxSize = actionRequest.getParameter("poolMaxSize");
                String poolInitSize = actionRequest.getParameter("poolInitSize");
                Object[] args = new String[]{this.trimStr(dsName), this.trimStr(PARENT_ID), this.trimStr(dependency), this.trimStr(dsName), this.trimStr(dbUser), dbPassword, this.trimStr(driverClass), this.trimStr(jdbcUrl), this.trimStr(poolMaxSize), this.trimStr(poolInitSize), this.trimStr(jndiName), this.trimStr(dbProperties)};
                helper.deployPlan(args);
                actionResponse.setRenderParameter("mode", "list");
            }
            return;
        }
        String name = actionRequest.getParameter("name");
        if (name != null) {
            ObjectName gbeanName = null;
            try {
                gbeanName = new ObjectName(name);
            }
            catch (MalformedObjectNameException e) {
                System.err.println("Invalid GBeanName: " + actionRequest.getParameter("name"));
                actionResponse.setRenderParameter("mode", "list");
                return;
            }
            if (name.indexOf(DATASOURCE_MSSQL) == -1) {
                this.connectionManagerRenderer.processAction(actionRequest, actionResponse, gbeanName);
            }
            this.getRenderer(gbeanName).processAction(actionRequest, actionResponse, gbeanName);
        }
    }

    private String trimStr(String str) {
        if (str != null) {
            return str.trim();
        }
        return "";
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
            return;
        }
        List dependencies = helper.getDependencies();
        renderRequest.setAttribute("dependencies", (Object)dependencies.toArray(new String[dependencies.size()]));
        String name = renderRequest.getParameter("name");
        String mode = renderRequest.getParameter("mode");
        String check = renderRequest.getParameter("check");
        if (ADDDS_MODE.equals(mode)) {
            this.addDSView.include(renderRequest, renderResponse);
            return;
        }
        boolean test = false;
        if (name == null || mode == null) {
            mode = "list";
        }
        if ("true".equals(check)) {
            test = true;
        }
        if ("detail".equals(mode) || "config".equals(mode)) {
            this.renderDetail(renderRequest, renderResponse, name);
        } else {
            this.renderList(renderRequest, renderResponse, name, test);
        }
    }

    private void renderList(RenderRequest renderRequest, RenderResponse renderResponse, String name, boolean check) throws PortletException, IOException {
        Set gbeanNames = this.kernel.listGBeans(this.DATABASE_QUERY);
        ArrayList<DataSourceInfo> dataSources = new ArrayList<DataSourceInfo>(gbeanNames.size());
        Iterator i = gbeanNames.iterator();
        while (i.hasNext()) {
            ObjectName gbeanName = (ObjectName)i.next();
            try {
                Class<?> cfInterface = Class.forName((String)this.kernel.getAttribute(gbeanName, "connectionFactoryInterface"));
                if (!this.connectionFactoryClass.isAssignableFrom(cfInterface)) {
                    continue;
                }
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
            DataSourceInfo info = new DataSourceInfo();
            info.setObjectName(gbeanName);
            info.setName(gbeanName.getKeyProperty("name"));
            try {
                info.setJndiName((String)this.kernel.getAttribute(gbeanName, "globalJNDIName"));
                info.setState(new Integer(this.kernel.getGBeanState(gbeanName)));
                if (gbeanName.toString().equals(name) && check) {
                    info.setWorking(true);
                    try {
                        Object cf = this.kernel.invoke(gbeanName, "$getResource");
                        this.testConnection(cf);
                        info.setMessage("Connected");
                    }
                    catch (Exception e) {
                        Throwable t = e;
                        String message = "Failed: ";
                        if (t.getMessage() != null) {
                            message = message + t.getMessage();
                        } else {
                            while (t.getMessage() == null) {
                                if ((t = t.getCause()) != null) {
                                    message = message + t.getMessage();
                                    continue;
                                }
                                message = message + "Unknown reason";
                            }
                        }
                        info.setMessage(message);
                    }
                } else {
                    info.setWorking(false);
                }
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
            dataSources.add(info);
        }
        Collections.sort(dataSources);
        renderRequest.setAttribute("dataSources", dataSources);
        this.normalView.include(renderRequest, renderResponse);
    }

    protected abstract void testConnection(Object var1) throws Exception;

    private void renderDetail(RenderRequest renderRequest, RenderResponse renderResponse, String name) throws PortletException, IOException {
        ObjectName gbeanName;
        try {
            gbeanName = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new PortletException("Malformed parameter name: " + renderRequest.getParameter("name"));
        }
        this.connectionManagerRenderer.addConnectionManagerInfo(renderRequest, gbeanName);
        this.getRenderer(gbeanName).render(renderRequest, renderResponse, gbeanName);
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.helpView.include(renderRequest, renderResponse);
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.kernel = KernelRegistry.getSingleKernel();
        PortletContext context = portletConfig.getPortletContext();
        this.normalView = context.getRequestDispatcher(this.NORMAL_VIEW);
        this.helpView = context.getRequestDispatcher(this.HELP_VIEW);
        this.addDSView = context.getRequestDispatcher("/WEB-INF/view/databasemanager/addDS.jsp");
        this.connectorRenderer = new ConnectorRenderer(this.kernel, context);
        this.setUpExplicitRenderers(context);
        this.connectionManagerRenderer = new ConnectionManagerRenderer(this.kernel);
    }

    protected abstract void setUpExplicitRenderers(PortletContext var1);

    private DetailViewRenderer getRenderer(ObjectName gbeanName) throws PortletException {
        DetailViewRenderer renderer;
        try {
            String clsName = (String)this.kernel.getAttribute(gbeanName, "managedConnectionFactoryClass");
            renderer = (DetailViewRenderer)RENDERERS.get(clsName);
            if (renderer == null) {
                renderer = this.connectorRenderer;
            }
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        return renderer;
    }

    public void destroy() {
        this.connectorRenderer = null;
        this.connectionManagerRenderer = null;
        this.normalView = null;
        this.kernel = null;
        RENDERERS.clear();
        super.destroy();
    }
}

