/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.databasemanager.connectionmanager;

import java.io.IOException;
import javax.management.ObjectName;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import org.apache.geronimo.console.databasemanager.connectionmanager.ConnectionManagerInfo;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContextImpl;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.kernel.Kernel;

public class ConnectionManagerRenderer {
    private final Kernel kernel;

    public ConnectionManagerRenderer(Kernel kernel) {
        this.kernel = kernel;
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse, ObjectName gbeanName) throws PortletException, IOException {
        if (!"detail".equals(actionRequest.getParameter("mode"))) {
            try {
                Integer oldidleTimeoutMinutes;
                Integer newidleTimeoutMinutes;
                Integer oldblockingTimeoutMilliseconds;
                Integer newblockingTimeoutMilliseconds;
                Integer oldPartitionMinSize;
                Integer newPartitionMinSize;
                J2eeContextImpl j2eeContext = J2eeContextImpl.newContext((ObjectName)gbeanName, (String)"JCAResource");
                ObjectName connectionManagerName = NameFactory.getComponentName(null, null, null, null, null, null, (String)"JCAConnectionManager", (J2eeContext)j2eeContext);
                Integer newPartitionMaxSize = Integer.decode(actionRequest.getParameter("partitionMaxSize"));
                Integer oldPartitionMaxSize = (Integer)this.kernel.getAttribute(connectionManagerName, "partitionMaxSize");
                if (!newPartitionMaxSize.equals(oldPartitionMaxSize)) {
                    this.kernel.setAttribute(connectionManagerName, "partitionMaxSize", (Object)newPartitionMaxSize);
                }
                if (!(newPartitionMinSize = Integer.decode(actionRequest.getParameter("partitionMinSize"))).equals(oldPartitionMinSize = (Integer)this.kernel.getAttribute(connectionManagerName, "partitionMinSize"))) {
                    this.kernel.setAttribute(connectionManagerName, "partitionMinSize", (Object)newPartitionMinSize);
                }
                if (!(newblockingTimeoutMilliseconds = Integer.decode(actionRequest.getParameter("blockingTimeoutMilliseconds"))).equals(oldblockingTimeoutMilliseconds = (Integer)this.kernel.getAttribute(connectionManagerName, "blockingTimeoutMilliseconds"))) {
                    this.kernel.setAttribute(connectionManagerName, "blockingTimeoutMilliseconds", (Object)newblockingTimeoutMilliseconds);
                }
                if (!(newidleTimeoutMinutes = Integer.decode(actionRequest.getParameter("idleTimeoutMinutes"))).equals(oldidleTimeoutMinutes = (Integer)this.kernel.getAttribute(connectionManagerName, "idleTimeoutMinutes"))) {
                    this.kernel.setAttribute(connectionManagerName, "idleTimeoutMinutes", (Object)newidleTimeoutMinutes);
                }
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
    }

    public void addConnectionManagerInfo(RenderRequest request, ObjectName gbeanName) throws PortletException, IOException {
        J2eeContextImpl j2eeContext = J2eeContextImpl.newContext((ObjectName)gbeanName, (String)"JCAResource");
        ConnectionManagerInfo info = null;
        try {
            ObjectName connectionManagerName = NameFactory.getComponentName(null, null, null, null, null, null, (String)"JCAConnectionManager", (J2eeContext)j2eeContext);
            info = new ConnectionManagerInfo((Integer)this.kernel.getAttribute(connectionManagerName, "partitionCount"), (Integer)this.kernel.getAttribute(connectionManagerName, "connectionCount"), (Integer)this.kernel.getAttribute(connectionManagerName, "idleConnectionCount"), (Integer)this.kernel.getAttribute(connectionManagerName, "partitionMaxSize"), (Integer)this.kernel.getAttribute(connectionManagerName, "partitionMinSize"), (Integer)this.kernel.getAttribute(connectionManagerName, "blockingTimeoutMilliseconds"), (Integer)this.kernel.getAttribute(connectionManagerName, "idleTimeoutMinutes"));
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        request.setAttribute("connectionManagerInfo", (Object)info);
    }
}

