/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.databasemanager.derby;

import java.io.IOException;
import javax.management.ObjectName;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.geronimo.console.databasemanager.DetailViewRenderer;
import org.apache.geronimo.console.databasemanager.derby.DerbyInfo;
import org.apache.geronimo.kernel.Kernel;

public class DerbyConnectorRenderer
implements DetailViewRenderer {
    private final Kernel kernel;
    private final PortletRequestDispatcher detailView;
    private final PortletRequestDispatcher configView;

    public DerbyConnectorRenderer(Kernel kernel, PortletContext context) {
        this.kernel = kernel;
        this.detailView = context.getRequestDispatcher("/WEB-INF/view/databasemanager/derby/normal.jsp");
        this.configView = context.getRequestDispatcher("/WEB-INF/view/databasemanager/derby/config.jsp");
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse, ObjectName gbeanName) throws PortletException, IOException {
        String password1 = actionRequest.getParameter("password1");
        if (!password1.equals(actionRequest.getParameter("password2"))) {
            actionResponse.setRenderParameter("badPassword", "true");
            actionResponse.setRenderParameter("mode", "config");
        } else {
            if (!"detail".equals(actionRequest.getParameter("mode"))) {
                try {
                    System.out.println("gbean = " + gbeanName.toString());
                    this.kernel.setAttribute(gbeanName, "UserName", (Object)actionRequest.getParameter("UserName"));
                    this.kernel.setAttribute(gbeanName, "Password", (Object)password1);
                    this.kernel.setAttribute(gbeanName, "DatabaseName", (Object)actionRequest.getParameter("DatabaseName"));
                    try {
                        this.kernel.setAttribute(gbeanName, "LoginTimeout", (Object)Integer.valueOf(actionRequest.getParameter("LoginTimeout")));
                    }
                    catch (NumberFormatException e) {}
                }
                catch (Exception e) {
                    throw new PortletException((Throwable)e);
                }
            }
            actionResponse.setRenderParameter("mode", "detail");
        }
        actionResponse.setRenderParameter("name", actionRequest.getParameter("name"));
    }

    public void render(RenderRequest request, RenderResponse response, ObjectName gbeanName) throws PortletException, IOException {
        request.setAttribute("badPassword", (Object)Boolean.valueOf(request.getParameter("badPassword")));
        DerbyInfo info = new DerbyInfo();
        try {
            info.setObjectName(gbeanName.toString());
            info.setName(gbeanName.getKeyProperty("name"));
            info.setUserName((String)this.kernel.getAttribute(gbeanName, "UserName"));
            info.setDatabaseName((String)this.kernel.getAttribute(gbeanName, "DatabaseName"));
            info.setCreateDatabase(((Boolean)this.kernel.getAttribute(gbeanName, "CreateDatabase")).toString());
            info.setLoginTimeout((Integer)this.kernel.getAttribute(gbeanName, "LoginTimeout"));
            info.setJndiName((String)this.kernel.getAttribute(gbeanName, "globalJNDIName"));
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        request.setAttribute("ds", (Object)info);
        if ("config".equals(request.getParameter("mode"))) {
            this.configView.include(request, response);
        } else {
            this.detailView.include(request, response);
        }
    }
}

