/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.databasemanager.generic;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.ObjectName;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.geronimo.console.databasemanager.DetailViewRenderer;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.kernel.Kernel;

public class ConnectorRenderer
implements DetailViewRenderer {
    private static final Set HIDDEN_ATTRIBUTES = new HashSet();
    private final Kernel kernel;
    private final PortletRequestDispatcher normalView;
    private final PortletRequestDispatcher configView;

    public ConnectorRenderer(Kernel kernel, PortletContext context) {
        this.kernel = kernel;
        this.normalView = context.getRequestDispatcher("/WEB-INF/view/databasemanager/generic/normal.jsp");
        this.configView = context.getRequestDispatcher("/WEB-INF/view/databasemanager/generic/config.jsp");
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse, ObjectName gbeanName) throws PortletException, IOException {
        throw new UnsupportedOperationException();
    }

    public void render(RenderRequest request, RenderResponse response, ObjectName gbeanName) throws PortletException, IOException {
        try {
            GBeanInfo gbeanInfo = this.kernel.getGBeanInfo(gbeanName);
            Set attributes = gbeanInfo.getAttributes();
            HashMap<String, Object> values = new HashMap<String, Object>(attributes.size());
            Iterator i = attributes.iterator();
            while (i.hasNext()) {
                GAttributeInfo attribute = (GAttributeInfo)i.next();
                String name = attribute.getName();
                if (HIDDEN_ATTRIBUTES.contains(name)) continue;
                Object value = this.kernel.getAttribute(gbeanName, name);
                values.put(name, value);
            }
            request.setAttribute("attributeMap", values);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        if ("config".equals(request.getParameter("mode"))) {
            this.configView.include(request, response);
        } else {
            this.normalView.include(request, response);
        }
    }

    static {
        HIDDEN_ATTRIBUTES.add("kernel");
        HIDDEN_ATTRIBUTES.add("connectionImplClass");
        HIDDEN_ATTRIBUTES.add("connectionInterface");
        HIDDEN_ATTRIBUTES.add("connectionFactoryInterface");
        HIDDEN_ATTRIBUTES.add("connectionFactoryImplClass");
        HIDDEN_ATTRIBUTES.add("implementedInterfaces");
        HIDDEN_ATTRIBUTES.add("managedConnectionFactoryClass");
        HIDDEN_ATTRIBUTES.add("recoveryXAResources");
    }
}

