/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.databasemanager.mssql;

import java.io.IOException;
import javax.management.ObjectName;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.geronimo.console.databasemanager.DetailViewRenderer;
import org.apache.geronimo.console.databasemanager.mssql.MSSQLInfo;
import org.apache.geronimo.kernel.Kernel;

public class MSSQLConnectorRenderer
implements DetailViewRenderer {
    private final Kernel kernel;
    private final PortletRequestDispatcher detailView;
    private final PortletRequestDispatcher configView;

    public MSSQLConnectorRenderer(Kernel kernel, PortletContext context) {
        this.kernel = kernel;
        this.detailView = context.getRequestDispatcher("/WEB-INF/view/databasemanager/mssql/normal.jsp");
        this.configView = context.getRequestDispatcher("/WEB-INF/view/databasemanager/mssql/config.jsp");
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse, ObjectName gbeanName) throws PortletException, IOException {
        String password1 = actionRequest.getParameter("password1");
        if (!password1.equals(actionRequest.getParameter("password2"))) {
            actionResponse.setRenderParameter("badPassword", "true");
            actionResponse.setRenderParameter("mode", "config");
        } else {
            if (!"detail".equals(actionRequest.getParameter("mode"))) {
                try {
                    this.kernel.setAttribute(gbeanName, "User", (Object)actionRequest.getParameter("user"));
                    this.kernel.setAttribute(gbeanName, "Password", (Object)password1);
                    this.kernel.setAttribute(gbeanName, "ServerName", (Object)actionRequest.getParameter("serverName"));
                    this.kernel.setAttribute(gbeanName, "PortNumber", (Object)new Integer(actionRequest.getParameter("portNumber")));
                    this.kernel.setAttribute(gbeanName, "DatabaseName", (Object)actionRequest.getParameter("databaseName"));
                }
                catch (Exception e) {
                    throw new PortletException((Throwable)e);
                }
            }
            actionResponse.setRenderParameter("mode", "detail");
        }
        actionResponse.setRenderParameter("name", actionRequest.getParameter("name"));
    }

    public void render(RenderRequest request, RenderResponse response, ObjectName gbeanName) throws PortletException, IOException {
        request.setAttribute("badPassword", (Object)Boolean.valueOf(request.getParameter("badPassword")));
        MSSQLInfo info = new MSSQLInfo();
        try {
            info.setObjectName(gbeanName.toString());
            info.setName(gbeanName.getKeyProperty("name"));
            info.setUser((String)this.kernel.getAttribute(gbeanName, "User"));
            info.setPassword((String)this.kernel.getAttribute(gbeanName, "Password"));
            info.setServerName((String)this.kernel.getAttribute(gbeanName, "ServerName"));
            info.setPortNumber(this.kernel.getAttribute(gbeanName, "PortNumber").toString());
            info.setDatabaseName((String)this.kernel.getAttribute(gbeanName, "DatabaseName"));
            info.setGlobalJNDIName((String)this.kernel.getAttribute(gbeanName, "globalJNDIName"));
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        request.setAttribute("ds", (Object)info);
        if ("config".equals(request.getParameter("mode"))) {
            this.configView.include(request, response);
        } else {
            this.detailView.include(request, response);
        }
    }
}

