/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.databasemanager.tranql;

import java.io.IOException;
import javax.management.ObjectName;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.geronimo.console.databasemanager.DetailViewRenderer;
import org.apache.geronimo.console.databasemanager.tranql.TranQLInfo;
import org.apache.geronimo.kernel.Kernel;

public class TranQLConnectorRenderer
implements DetailViewRenderer {
    private final Kernel kernel;
    private final PortletRequestDispatcher detailView;
    private final PortletRequestDispatcher configView;

    public TranQLConnectorRenderer(Kernel kernel, PortletContext context) {
        this.kernel = kernel;
        this.detailView = context.getRequestDispatcher("/WEB-INF/view/databasemanager/tranql/normal.jsp");
        this.configView = context.getRequestDispatcher("/WEB-INF/view/databasemanager/tranql/config.jsp");
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse, ObjectName gbeanName) throws PortletException, IOException {
        String password1 = actionRequest.getParameter("password1");
        if (!password1.equals(actionRequest.getParameter("password2"))) {
            actionResponse.setRenderParameter("badPassword", "true");
            actionResponse.setRenderParameter("mode", "config");
        } else {
            if (!"detail".equals(actionRequest.getParameter("mode"))) {
                try {
                    this.kernel.setAttribute(gbeanName, "UserName", (Object)actionRequest.getParameter("UserName"));
                    this.kernel.setAttribute(gbeanName, "Password", (Object)password1);
                    this.kernel.setAttribute(gbeanName, "Driver", (Object)actionRequest.getParameter("Driver"));
                    this.kernel.setAttribute(gbeanName, "ConnectionURL", (Object)actionRequest.getParameter("ConnectionURL"));
                    this.kernel.setAttribute(gbeanName, "ExceptionSorterClass", (Object)actionRequest.getParameter("ExceptionSorterClass"));
                }
                catch (Exception e) {
                    throw new PortletException((Throwable)e);
                }
            }
            actionResponse.setRenderParameter("mode", "detail");
        }
        actionResponse.setRenderParameter("name", actionRequest.getParameter("name"));
    }

    public void render(RenderRequest request, RenderResponse response, ObjectName gbeanName) throws PortletException, IOException {
        request.setAttribute("badPassword", (Object)Boolean.valueOf(request.getParameter("badPassword")));
        TranQLInfo info = new TranQLInfo();
        try {
            info.setObjectName(gbeanName.toString());
            info.setName(gbeanName.getKeyProperty("name"));
            info.setDriver((String)this.kernel.getAttribute(gbeanName, "Driver"));
            info.setConnectionURL((String)this.kernel.getAttribute(gbeanName, "ConnectionURL"));
            info.setUserName((String)this.kernel.getAttribute(gbeanName, "UserName"));
            info.setExceptionSorterClass((String)this.kernel.getAttribute(gbeanName, "ExceptionSorterClass"));
            info.setjndiName((String)this.kernel.getAttribute(gbeanName, "globalJNDIName"));
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        request.setAttribute("ds", (Object)info);
        if ("config".equals(request.getParameter("mode"))) {
            this.configView.include(request, response);
        } else {
            this.detailView.include(request, response);
        }
    }
}

