/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.derbylogmanager;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.console.util.KernelHelper;

public class DerbyLogHelper
extends KernelHelper {
    private static ObjectName objName;
    private static ArrayList logs;
    private static boolean cached;
    private static int lineCount;
    private static final String DATE_PATTERN_REGEX = "2004";
    private static final String DERBY_SYSTEM_HOME = "derby.system.home";
    private static final String DERBY_SYS_HOME_PROP = "derbySystemHome";
    private static final String LOG_FILENAME = "derby.log";

    public static Collection getLogs() throws IOException {
        if (!cached) {
            DerbyLogHelper.refresh();
        }
        return logs;
    }

    public static void refresh() throws IOException {
        cached = false;
        logs.clear();
        BufferedReader in = new BufferedReader(DerbyLogHelper.getFileReader());
        lineCount = 0;
        Stack<String> holder = new Stack<String>();
        String line = in.readLine();
        while (line != null) {
            holder.push(line);
            ++lineCount;
            line = in.readLine();
        }
        logs.addAll(holder);
        cached = true;
    }

    public static int getLineCount() {
        return lineCount;
    }

    private static InputStreamReader getFileReader() throws IOException {
        String pathToFile = DerbyLogHelper.getSystemHome() + File.separator + LOG_FILENAME;
        return new FileReader(new File(pathToFile));
    }

    public static String getSystemHome() {
        return System.getProperty(DERBY_SYSTEM_HOME);
    }

    static {
        logs = new ArrayList();
        cached = false;
        lineCount = 0;
        try {
            objName = new ObjectName("geronimo.server:name=DerbySystem,J2EEServer=geronimo,J2EEApplication=null,j2eeType=GBean,J2EEModule=null");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }
}

