/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.infomanager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.geronimo.console.BasePortlet;
import org.apache.geronimo.console.util.PortletManager;

public class JavaSystemInfoPortlet
extends BasePortlet {
    private static final String NORMALVIEW_JSP = "/WEB-INF/view/infomanager/javaSysNormal.jsp";
    private static final String MAXIMIZEDVIEW_JSP = "/WEB-INF/view/infomanager/javaSysMaximized.jsp";
    private static final String HELPVIEW_JSP = "/WEB-INF/view/infomanager/javaSysHelp.jsp";
    private PortletRequestDispatcher normalView;
    private PortletRequestDispatcher maximizedView;
    private PortletRequestDispatcher helpView;

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
            return;
        }
        Properties javaSysProps = PortletManager.getCurrentJVM((PortletRequest)renderRequest).getSystemProperties();
        renderRequest.setAttribute("javaSysProps", (Object)javaSysProps);
        String sep = (String)javaSysProps.get("path.separator");
        String cp = (String)javaSysProps.get("sun.boot.class.path");
        if (cp != null) {
            renderRequest.setAttribute("bootClassPathList", (Object)this.split(cp, sep));
        }
        if ((cp = (String)javaSysProps.get("java.library.path")) != null) {
            renderRequest.setAttribute("javaLibraryPath", (Object)this.split(cp, sep));
        }
        if ((cp = (String)javaSysProps.get("java.class.path")) != null) {
            renderRequest.setAttribute("javaClassPath", (Object)this.split(cp, sep));
        }
        if (WindowState.NORMAL.equals((Object)renderRequest.getWindowState())) {
            this.normalView.include(renderRequest, renderResponse);
        } else {
            this.maximizedView.include(renderRequest, renderResponse);
        }
    }

    private List split(String path, String sep) {
        StringTokenizer st = new StringTokenizer(path, sep);
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return l;
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.helpView.include(renderRequest, renderResponse);
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.normalView = portletConfig.getPortletContext().getRequestDispatcher(NORMALVIEW_JSP);
        this.maximizedView = portletConfig.getPortletContext().getRequestDispatcher(MAXIMIZEDVIEW_JSP);
        this.helpView = portletConfig.getPortletContext().getRequestDispatcher(HELPVIEW_JSP);
    }

    public void destroy() {
        this.normalView = null;
        this.maximizedView = null;
        this.helpView = null;
        super.destroy();
    }
}

