/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.infomanager;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.geronimo.console.BasePortlet;
import org.apache.geronimo.console.util.PortletManager;
import org.apache.geronimo.management.geronimo.JVM;

public class ServerInfoPortlet
extends BasePortlet {
    private static final String NORMALVIEW_JSP = "/WEB-INF/view/infomanager/svrInfoNormal.jsp";
    private static final String MAXIMIZEDVIEW_JSP = "/WEB-INF/view/infomanager/svrInfoMaximized.jsp";
    private static final String HELPVIEW_JSP = "/WEB-INF/view/infomanager/svrInfoHelp.jsp";
    private PortletRequestDispatcher normalView;
    private PortletRequestDispatcher maximizedView;
    private PortletRequestDispatcher helpView;

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
            return;
        }
        HashMap<String, Date> svrProps = new HashMap<String, Date>();
        HashMap<String, Object> jvmProps = new HashMap<String, Object>();
        JVM jvm = PortletManager.getCurrentJVM((PortletRequest)renderRequest);
        Date bootDate = jvm.getKernelBootTime();
        svrProps.put("Kernel Boot Time", bootDate);
        renderRequest.setAttribute("svrProps", svrProps);
        jvmProps.put("Java Version", jvm.getJavaVersion());
        jvmProps.put("Java Vendor", jvm.getJavaVendor());
        jvmProps.put("Node", jvm.getNode());
        jvmProps.put("Available Processors", new Integer(jvm.getAvailableProcessors()));
        renderRequest.setAttribute("jvmProps", jvmProps);
        if (WindowState.NORMAL.equals((Object)renderRequest.getWindowState())) {
            this.normalView.include(renderRequest, renderResponse);
        } else {
            this.maximizedView.include(renderRequest, renderResponse);
        }
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.helpView.include(renderRequest, renderResponse);
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.normalView = portletConfig.getPortletContext().getRequestDispatcher(NORMALVIEW_JSP);
        this.maximizedView = portletConfig.getPortletContext().getRequestDispatcher(MAXIMIZEDVIEW_JSP);
        this.helpView = portletConfig.getPortletContext().getRequestDispatcher(HELPVIEW_JSP);
    }

    public void destroy() {
        this.normalView = null;
        this.maximizedView = null;
        this.helpView = null;
        super.destroy();
    }
}

