/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.internaldb;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.geronimo.console.BasePortlet;
import org.apache.geronimo.console.internaldb.DBViewerHelper;
import org.apache.geronimo.console.internaldb.DerbyConnectionUtil;

public class DBViewerPortlet
extends BasePortlet {
    private static final int RDBMS_DERBY = 1;
    private static final int RDBMS_MSSQL = 2;
    private static final String MAXIMIZEDVIEW_JSP = "/WEB-INF/view/internaldb/dbViewerMaximized.jsp";
    private static final String HELPVIEW_JSP = "/WEB-INF/view/internaldb/dbViewerHelp.jsp";
    private static final String LISTDATABASES_JSP = "/WEB-INF/view/internaldb/listDatabases.jsp";
    private static final String LISTTABLES_JSP = "/WEB-INF/view/internaldb/listTables.jsp";
    private static final String VIEWTABLECONTENTS_JSP = "/WEB-INF/view/internaldb/viewTableContents.jsp";
    private static final String LISTDB_ACTION = "listDatabases";
    private static final String LISTTBLS_ACTION = "listTables";
    private static final String VIEWTBLCONTENTS_ACTION = "viewTableContents";
    private static final String DERBY_HOME = System.getProperty("derby.system.home");
    private static DBViewerHelper helper = new DBViewerHelper();
    private PortletRequestDispatcher maximizedView;
    private PortletRequestDispatcher helpView;
    private PortletRequestDispatcher listDatabasesView;
    private PortletRequestDispatcher listTablesView;
    private PortletRequestDispatcher viewTableContentsView;

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String action = actionRequest.getParameter("action");
        String db = actionRequest.getParameter("db");
        String tbl = actionRequest.getParameter("tbl");
        String viewTables = actionRequest.getParameter("viewTables");
        String rdbms = actionRequest.getParameter("rdbms");
        if (action != null) {
            actionResponse.setRenderParameter("action", action);
        }
        if (db != null) {
            actionResponse.setRenderParameter("db", db);
        }
        if (tbl != null) {
            actionResponse.setRenderParameter("tbl", tbl);
        }
        if (viewTables != null) {
            actionResponse.setRenderParameter("viewTables", viewTables);
        }
        if (rdbms != null) {
            actionResponse.setRenderParameter("rdbms", rdbms);
        }
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        int rdbmsParam;
        if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
            return;
        }
        String action = renderRequest.getParameter("action");
        String db = renderRequest.getParameter("db");
        String tbl = renderRequest.getParameter("tbl");
        String viewTables = renderRequest.getParameter("viewTables");
        String rdbms = renderRequest.getParameter("rdbms");
        int n = rdbmsParam = rdbms == null ? 1 : Integer.parseInt(rdbms);
        if (WindowState.NORMAL.equals((Object)renderRequest.getWindowState())) {
            if (rdbmsParam == 1) {
                if ((LISTTBLS_ACTION.equals(action) || VIEWTBLCONTENTS_ACTION.equals(action)) && !helper.isDBValid(DERBY_HOME, db)) {
                    System.out.println("ERROR: db not valid: " + db);
                    action = "";
                }
                if (VIEWTBLCONTENTS_ACTION.equals(action) && !helper.isTblValid(db, tbl)) {
                    System.out.println("ERROR: table not valid: " + tbl);
                    action = "";
                }
            }
            renderRequest.setAttribute("rdbms", (Object)rdbms);
            if (LISTTBLS_ACTION.equals(action)) {
                renderRequest.setAttribute("db", (Object)db);
                renderRequest.setAttribute("viewTables", (Object)viewTables);
                renderRequest.setAttribute("ds", (Object)DerbyConnectionUtil.getDataSource(db));
                this.listTablesView.include(renderRequest, renderResponse);
            } else if (VIEWTBLCONTENTS_ACTION.equals(action)) {
                renderRequest.setAttribute("db", (Object)db);
                renderRequest.setAttribute("tbl", (Object)tbl);
                renderRequest.setAttribute("viewTables", (Object)viewTables);
                renderRequest.setAttribute("ds", (Object)DerbyConnectionUtil.getDataSource(db));
                this.viewTableContentsView.include(renderRequest, renderResponse);
            } else {
                renderRequest.setAttribute("databases", (Object)helper.getDerbyDatabases(DERBY_HOME));
                this.listDatabasesView.include(renderRequest, renderResponse);
            }
        } else {
            this.maximizedView.include(renderRequest, renderResponse);
        }
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.helpView.include(renderRequest, renderResponse);
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.maximizedView = portletConfig.getPortletContext().getRequestDispatcher(MAXIMIZEDVIEW_JSP);
        this.helpView = portletConfig.getPortletContext().getRequestDispatcher(HELPVIEW_JSP);
        this.listDatabasesView = portletConfig.getPortletContext().getRequestDispatcher(LISTDATABASES_JSP);
        this.listTablesView = portletConfig.getPortletContext().getRequestDispatcher(LISTTABLES_JSP);
        this.viewTableContentsView = portletConfig.getPortletContext().getRequestDispatcher(VIEWTABLECONTENTS_JSP);
    }

    public void destroy() {
        this.maximizedView = null;
        this.helpView = null;
        this.listDatabasesView = null;
        this.listTablesView = null;
        this.viewTableContentsView = null;
        super.destroy();
    }
}

