/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.internaldb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.management.ObjectName;
import javax.sql.DataSource;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.kernel.jmx.JMXUtil;

public class DerbyConnectionUtil {
    public static final String CREATE_DB_PROP = ";create=true";
    public static final String SHUTDOWN_DB_PROP = ";shutdown=true";
    private static final int RDBMS_DERBY = 1;
    private static final int RDBMS_MSSQL = 2;
    private static final String SYSTEM_DB = "SYSTEMDATABASE";
    private static final String DERBY_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String PROTOCOL = "jdbc:derby:";
    private static final String EMPTY_PROPS = "";
    private static final ObjectName SYSTEM_DATASOURCE_NAME = JMXUtil.getObjectName((String)"geronimo.server:J2EEApplication=null,J2EEServer=geronimo,JCAResource=org/apache/geronimo/SystemDatabase,j2eeType=JCAManagedConnectionFactory,name=SystemDatasource");

    private static Connection getConnection(String dbName, String properties, String protocol, String driver) throws SQLException {
        try {
            Class.forName(driver).newInstance();
        }
        catch (Exception e) {
            return null;
        }
        if (SYSTEM_DB.equalsIgnoreCase(dbName)) {
            return DerbyConnectionUtil.getSystemDBConnection();
        }
        return DriverManager.getConnection(protocol + dbName + properties);
    }

    public static Connection getDerbyConnection(String dbName, String properties) throws SQLException {
        return DerbyConnectionUtil.getConnection(dbName, properties, PROTOCOL, DERBY_DRIVER);
    }

    public static Connection getDerbyConnection(String dbName) throws SQLException {
        return DerbyConnectionUtil.getDerbyConnection(dbName, EMPTY_PROPS);
    }

    public static Connection getSystemDBConnection() throws SQLException {
        DataSource ds = null;
        try {
            ds = DerbyConnectionUtil.getDataSource(SYSTEM_DB);
            return ds.getConnection();
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    public static DataSource getDataSource(String dbName) {
        try {
            if (SYSTEM_DB.equalsIgnoreCase(dbName)) {
                return (DataSource)KernelRegistry.getSingleKernel().invoke(SYSTEM_DATASOURCE_NAME, "$getResource");
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

