/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.internaldb;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import org.apache.geronimo.console.internaldb.DerbyConnectionUtil;

public class InternalDBHelper {
    private static final int RDBMS_DERBY = 1;
    private static final int RDBMS_MSSQL = 2;
    private static final String JNDI_DERBY = "java:comp/env/SystemDatasource";
    private static final Map derbyDBInfo = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Map getDBInfo() {
        block26: {
            derbyDBInfo.clear();
            Connection conn = null;
            conn = DerbyConnectionUtil.getSystemDBConnection();
            DatabaseMetaData dbMD = conn.getMetaData();
            derbyDBInfo.put("URL", this.removeNull(dbMD.getURL()));
            derbyDBInfo.put("Username", this.removeNull(dbMD.getUserName()));
            derbyDBInfo.put("Read Only", this.removeNull(String.valueOf(dbMD.isReadOnly())));
            derbyDBInfo.put("DB Product Name", this.removeNull(dbMD.getDatabaseProductName()));
            derbyDBInfo.put("DB Product Version", this.removeNull(dbMD.getDatabaseProductVersion()));
            derbyDBInfo.put("DB Major Version", this.removeNull(String.valueOf(dbMD.getDatabaseMajorVersion())));
            derbyDBInfo.put("DB Minor Version", this.removeNull(String.valueOf(dbMD.getDatabaseMinorVersion())));
            derbyDBInfo.put("Driver Name", this.removeNull(dbMD.getDriverName()));
            derbyDBInfo.put("Driver Version", this.removeNull(dbMD.getDriverVersion()));
            derbyDBInfo.put("Driver Major Version", this.removeNull(String.valueOf(dbMD.getDriverMajorVersion())));
            derbyDBInfo.put("Driver Minor Version", this.removeNull(String.valueOf(dbMD.getDriverMinorVersion())));
            derbyDBInfo.put("JDBC Major Version", this.removeNull(String.valueOf(dbMD.getJDBCMajorVersion())));
            derbyDBInfo.put("JDBC Minor Version", this.removeNull(String.valueOf(dbMD.getJDBCMinorVersion())));
            derbyDBInfo.put("Numeric Functions", this.removeNull(dbMD.getNumericFunctions()));
            derbyDBInfo.put("String Functions", this.removeNull(dbMD.getStringFunctions()));
            derbyDBInfo.put("System Functions", this.removeNull(dbMD.getSystemFunctions()));
            derbyDBInfo.put("Time Date Functions", this.removeNull(dbMD.getTimeDateFunctions()));
            derbyDBInfo.put("Supported SQL Keywords", this.removeNull(dbMD.getSQLKeywords().replace(',', ' ')));
            derbyDBInfo.put("Supported Types", this.removeNull(this.getColumnData(dbMD.getTypeInfo(), "TYPE_NAME")));
            derbyDBInfo.put("Table Types", this.removeNull(this.getColumnData(dbMD.getTableTypes(), "TABLE_TYPE")));
            derbyDBInfo.put("Schemas", this.removeNull(this.getColumnData(dbMD.getSchemas(), "TABLE_SCHEM")));
            String tx = null;
            switch (dbMD.getDefaultTransactionIsolation()) {
                case 0: {
                    tx = "not supported";
                    break;
                }
                case 2: {
                    tx = "dirty reads are prevented; non-repeatable reads and phantom reads can occur";
                    break;
                }
                case 1: {
                    tx = "dirty reads, non-repeatable reads and phantom reads can occur";
                    break;
                }
                case 4: {
                    tx = "dirty reads and non-repeatable reads are prevented; phantom reads can occur";
                    break;
                }
                case 8: {
                    tx = "dirty reads, non-repeatable reads and phantom reads are prevented";
                    break;
                }
                default: {
                    tx = "";
                }
            }
            derbyDBInfo.put("Default Transaction Isolation", this.removeNull(tx));
            String holdability = null;
            switch (dbMD.getResultSetHoldability()) {
                case 1: {
                    holdability = "hold cursors over commit";
                    break;
                }
                case 2: {
                    holdability = "close cursors at commit";
                    break;
                }
                default: {
                    holdability = "";
                }
            }
            derbyDBInfo.put("Result Set Holdability", this.removeNull(holdability));
            String sqlStateType = null;
            switch (dbMD.getSQLStateType()) {
                case 1: {
                    sqlStateType = "X/Open SQL CLI";
                    break;
                }
                case 2: {
                    sqlStateType = "SQL99";
                    break;
                }
                default: {
                    sqlStateType = "";
                }
            }
            derbyDBInfo.put("SQL State Type", this.removeNull(sqlStateType));
            Object var7_7 = null;
            try {
                if (conn != null) {
                    conn.close();
                }
                break block26;
            }
            catch (SQLException e2) {}
            break block26;
            {
                catch (SQLException e) {
                    this.printSQLError(e);
                    Object var7_8 = null;
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        break block26;
                    }
                    catch (SQLException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return derbyDBInfo;
    }

    private String removeNull(String s) {
        return s == null ? "" : s;
    }

    private String getColumnData(ResultSet rs, String colName) {
        StringBuffer result = new StringBuffer();
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int selectedCol = -1;
            int numberOfColumns = rsmd.getColumnCount();
            for (int i = 1; i <= numberOfColumns; ++i) {
                String columnName = rsmd.getColumnName(i);
                if (!columnName.equals(colName)) continue;
                selectedCol = i;
                break;
            }
            boolean firstData = true;
            while (rs.next()) {
                for (int i = 1; i <= numberOfColumns; ++i) {
                    if (i != selectedCol) continue;
                    if (firstData) {
                        firstData = false;
                    } else {
                        result.append(',');
                    }
                    String columnValue = rs.getString(i);
                    result.append(columnValue);
                }
            }
        }
        catch (SQLException e) {
            this.printSQLError(e);
        }
        return result.toString();
    }

    private void printSQLError(SQLException e) {
        while (e != null) {
            System.out.println(e.toString());
            e = e.getNextException();
        }
    }
}

