/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.internaldb;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.geronimo.console.BasePortlet;
import org.apache.geronimo.console.internaldb.InternalDBHelper;

public class InternalDBPortlet
extends BasePortlet {
    private static final String NORMALVIEW_JSP = "/WEB-INF/view/internaldb/internalDBNormal.jsp";
    private static final String MAXIMIZEDVIEW_JSP = "/WEB-INF/view/internaldb/internalDBMaximized.jsp";
    private static final String HELPVIEW_JSP = "/WEB-INF/view/internaldb/internalDBHelp.jsp";
    private static InternalDBHelper helper = new InternalDBHelper();
    private static Map javaSysInfo = new HashMap();
    private PortletRequestDispatcher normalView;
    private PortletRequestDispatcher maximizedView;
    private PortletRequestDispatcher helpView;

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String rdbms = actionRequest.getParameter("rdbms");
        if (rdbms != null) {
            actionResponse.setRenderParameter("rdbms", rdbms);
        }
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
            return;
        }
        String rdbmsParam = renderRequest.getParameter("rdbms");
        int rdbms = 1;
        if (rdbmsParam != null && rdbmsParam.length() > 0) {
            rdbms = Integer.parseInt(rdbmsParam);
        }
        Map internalDB = helper.getDBInfo();
        renderRequest.setAttribute("internalDB", (Object)internalDB);
        if (WindowState.NORMAL.equals((Object)renderRequest.getWindowState())) {
            this.normalView.include(renderRequest, renderResponse);
        } else {
            this.maximizedView.include(renderRequest, renderResponse);
        }
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.helpView.include(renderRequest, renderResponse);
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.normalView = portletConfig.getPortletContext().getRequestDispatcher(NORMALVIEW_JSP);
        this.maximizedView = portletConfig.getPortletContext().getRequestDispatcher(MAXIMIZEDVIEW_JSP);
        this.helpView = portletConfig.getPortletContext().getRequestDispatcher(HELPVIEW_JSP);
    }

    public void destroy() {
        this.normalView = null;
        this.maximizedView = null;
        this.helpView = null;
        super.destroy();
    }
}

