/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.internaldb;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.geronimo.console.internaldb.DerbyConnectionUtil;

public class RunSQLHelper {
    public static final String SQL_SUCCESS_MSG = "SQL command/s successful";
    public static final String SQL_EMPTY_MSG = "SQL Command/s can't be empty";
    private static final String DB_CREATED_MSG = "Database created";
    private static final String DB_DELETED_MSG = "Database deleted";
    private static final String DERBY_BACKUP_FOLDER = "derby.backup";
    private static final String PARENT_FOLDER = "..";
    private static final String BAK_EXTENSION = ".bak";
    private static final String BAK_PREFIX = "BAK_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String createDB(String dbName) {
        String result;
        block11: {
            result = "Database created: " + dbName;
            Connection conn = null;
            conn = DerbyConnectionUtil.getDerbyConnection(dbName, ";create=true");
            Object var6_4 = null;
            try {
                if (conn != null) {
                    conn.close();
                }
                break block11;
            }
            catch (SQLException e2) {
                result = "Problem closing DB connection";
            }
            break block11;
            {
                catch (Throwable e) {
                    result = e instanceof SQLException ? this.getSQLError((SQLException)e) : e.getMessage();
                    Object var6_5 = null;
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        break block11;
                    }
                    catch (SQLException e2) {
                        result = "Problem closing DB connection";
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    result = "Problem closing DB connection";
                }
                throw throwable;
            }
        }
        return result;
    }

    public String backupDB(String derbyHome, String dbName) {
        return "";
    }

    public String restoreDB(String derbyHome, String dbName) {
        return "";
    }

    public String deleteDB(String derbyHome, String dbName) {
        String result = "Database deleted: " + dbName;
        if (!this.shutdownDB(dbName)) {
            result = "Database not deleted: " + dbName + " Couldn't shutdown db: " + dbName;
            return result;
        }
        try {
            File derbyBackupFolder = new File(derbyHome + File.separatorChar + PARENT_FOLDER + File.separatorChar + DERBY_BACKUP_FOLDER);
            if (!derbyBackupFolder.exists() && !derbyBackupFolder.mkdirs()) {
                result = "Database not deleted: " + dbName + " Derby backup folder not created: " + derbyBackupFolder;
                return result;
            }
            File oldDBFolder = new File(derbyHome + File.separatorChar + dbName);
            if (oldDBFolder.exists()) {
                File tmpFile = File.createTempFile(BAK_PREFIX + dbName, BAK_EXTENSION, derbyBackupFolder);
                File newDBFolder = new File(tmpFile.getAbsolutePath());
                if (tmpFile.delete() && newDBFolder.mkdirs() && !oldDBFolder.renameTo(new File(newDBFolder, oldDBFolder.getName()))) {
                    result = "Database not deleted: " + dbName + " DB folder not renamed";
                    return result;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String runSQL(String dbName, String sql) {
        String result;
        block18: {
            result = SQL_SUCCESS_MSG;
            if (sql == null || sql.trim().length() == 0) {
                result = SQL_EMPTY_MSG;
                return result;
            }
            Connection conn = null;
            Statement s = null;
            conn = DerbyConnectionUtil.getDerbyConnection(dbName);
            conn.setAutoCommit(false);
            s = conn.createStatement();
            String[] sqlCmds = sql.split(";");
            for (int i = 0; i < sqlCmds.length; ++i) {
                if (sqlCmds[i].trim().length() <= 0) continue;
                System.out.println("SQL" + i + ": <" + sqlCmds[i].trim() + ">");
                s.execute(sqlCmds[i]);
            }
            conn.commit();
            Object var9_9 = null;
            try {
                if (s != null) {
                    s.close();
                }
                if (conn != null) {
                    conn.close();
                }
                break block18;
            }
            catch (SQLException e2) {
                if (SQL_SUCCESS_MSG.equals(result)) {
                    result = "Problem closing DB connection: " + e2.getMessage();
                }
                break block18;
            }
            {
                catch (Throwable e) {
                    result = e instanceof SQLException ? this.getSQLError((SQLException)e) : e.getMessage();
                    Object var9_10 = null;
                    try {
                        if (s != null) {
                            s.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                        break block18;
                    }
                    catch (SQLException e2) {
                        if (SQL_SUCCESS_MSG.equals(result)) {
                            result = "Problem closing DB connection: " + e2.getMessage();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block19: {
                    Object var9_11 = null;
                    try {
                        if (s != null) {
                            s.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException e2) {
                        if (!SQL_SUCCESS_MSG.equals(result)) break block19;
                        result = "Problem closing DB connection: " + e2.getMessage();
                    }
                }
                throw throwable;
            }
        }
        return result;
    }

    private boolean shutdownDB(String dbName) {
        boolean ok = true;
        boolean gotSQLExc = false;
        try {
            DerbyConnectionUtil.getDerbyConnection(dbName, ";shutdown=true");
        }
        catch (SQLException se) {
            gotSQLExc = true;
        }
        if (!gotSQLExc) {
            ok = false;
        }
        return ok;
    }

    private String getSQLError(SQLException e) {
        StringBuffer errorMsg = new StringBuffer();
        while (e != null) {
            errorMsg.append(e.getMessage());
            errorMsg.append(" * ");
            e = e.getNextException();
        }
        return errorMsg.toString();
    }

    public static void main(String[] args) {
        new RunSQLHelper().runSQL("derbyDB4", "create table derbyTbl1(num int, addr varchar(40));create table derbyTbl2(num int, addr varchar(40));create table derbyTbl3(num int, addr varchar(40));insert into derb");
    }
}

