/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.internaldb;

import java.io.IOException;
import java.util.Collection;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.geronimo.console.BasePortlet;
import org.apache.geronimo.console.internaldb.DBViewerHelper;
import org.apache.geronimo.console.internaldb.DerbyConnectionUtil;
import org.apache.geronimo.console.internaldb.RunSQLHelper;

public class RunSQLPortlet
extends BasePortlet {
    private static final String NORMALVIEW_JSP = "/WEB-INF/view/internaldb/runSQLNormal.jsp";
    private static final String MAXIMIZEDVIEW_JSP = "/WEB-INF/view/internaldb/runSQLMaximized.jsp";
    private static final String HELPVIEW_JSP = "/WEB-INF/view/internaldb/runSQLHelp.jsp";
    private static final String CREATEDB_ACTION = "Create";
    private static final String DELETEDB_ACTION = "Delete";
    private static final String RUNSQL_ACTION = "Run SQL";
    private static final String BACKUPDB_ACTION = "Backup";
    private static final String RESTOREDB_ACTION = "Restore";
    private static RunSQLHelper sqlHelper = new RunSQLHelper();
    private static DBViewerHelper dbHelper = new DBViewerHelper();
    private static String derbyHome = System.getProperty("derby.system.home");
    private PortletRequestDispatcher normalView;
    private PortletRequestDispatcher maximizedView;
    private PortletRequestDispatcher helpView;
    private Collection databases;
    private String action;
    private String createDB;
    private String deleteDB;
    private String useDB;
    private String backupDB;
    private String restoreDB;
    private String sqlStmts;
    private String actionResult;

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        this.action = actionRequest.getParameter("action");
        this.createDB = actionRequest.getParameter("createDB");
        this.deleteDB = actionRequest.getParameter("deleteDB");
        this.useDB = actionRequest.getParameter("useDB");
        this.backupDB = actionRequest.getParameter("backupDB");
        this.restoreDB = actionRequest.getParameter("restoreDB");
        this.sqlStmts = actionRequest.getParameter("sqlStmts");
        this.actionResult = "";
        if (CREATEDB_ACTION.equals(this.action)) {
            this.actionResult = sqlHelper.createDB(this.createDB);
        } else if (DELETEDB_ACTION.equals(this.action)) {
            this.actionResult = sqlHelper.deleteDB(derbyHome, this.deleteDB);
        } else if (RUNSQL_ACTION.equals(this.action)) {
            this.actionResult = sqlHelper.runSQL(this.useDB, this.sqlStmts);
        } else if (BACKUPDB_ACTION.equals(this.action)) {
            this.actionResult = sqlHelper.backupDB(derbyHome, this.backupDB);
        } else if (RESTOREDB_ACTION.equals(this.action)) {
            this.actionResult = sqlHelper.restoreDB(derbyHome, this.restoreDB);
        }
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
            return;
        }
        if (WindowState.NORMAL.equals((Object)renderRequest.getWindowState())) {
            this.databases = dbHelper.getDerbyDatabases(derbyHome);
            renderRequest.setAttribute("databases", (Object)this.databases);
            if (RUNSQL_ACTION.equals(this.action)) {
                String singleSelectStmt;
                if (this.sqlStmts != null && this.sqlStmts.trim().indexOf(59) == -1 && this.sqlStmts.trim().toUpperCase().startsWith("SELECT") && "SQL command/s successful".equals(this.actionResult)) {
                    singleSelectStmt = this.sqlStmts.trim();
                    this.actionResult = "";
                } else {
                    singleSelectStmt = "";
                }
                renderRequest.setAttribute("useDB", (Object)this.useDB);
                renderRequest.setAttribute("singleSelectStmt", (Object)singleSelectStmt);
                renderRequest.setAttribute("ds", (Object)DerbyConnectionUtil.getDataSource(this.useDB));
            }
            if (this.action != null && this.action.trim().length() > 0) {
                renderRequest.setAttribute("actionResult", (Object)this.actionResult);
                this.action = null;
            }
            this.normalView.include(renderRequest, renderResponse);
        } else {
            this.maximizedView.include(renderRequest, renderResponse);
        }
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.helpView.include(renderRequest, renderResponse);
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.normalView = portletConfig.getPortletContext().getRequestDispatcher(NORMALVIEW_JSP);
        this.maximizedView = portletConfig.getPortletContext().getRequestDispatcher(MAXIMIZEDVIEW_JSP);
        this.helpView = portletConfig.getPortletContext().getRequestDispatcher(HELPVIEW_JSP);
        this.databases = dbHelper.getDerbyDatabases(derbyHome);
    }

    public void destroy() {
        this.normalView = null;
        this.maximizedView = null;
        this.helpView = null;
        super.destroy();
    }
}

