/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.jmsmanager;

import javax.jms.Queue;

public class DestinationInfo
implements Comparable {
    private final String name;
    private final String physicalName;
    private final Class type;
    private final String applicationName;
    private final String moduleName;
    private final String configURI;

    public DestinationInfo(String name, String physicalName, Class type, String applicationName, String moduleName, String configURI) {
        this.name = name;
        this.physicalName = physicalName;
        this.type = type;
        this.applicationName = applicationName;
        this.moduleName = moduleName;
        this.configURI = configURI;
    }

    public String getName() {
        return this.name;
    }

    public String getPhysicalName() {
        return this.physicalName;
    }

    public Class getType() {
        return this.type;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getConfigURI() {
        return this.configURI;
    }

    public boolean isViewable() {
        return Queue.class.isAssignableFrom(this.type) || this.isConsoleManaged();
    }

    public boolean isRemovable() {
        return this.isConsoleManaged();
    }

    private boolean isConsoleManaged() {
        return this.configURI.indexOf("runtimedestination/" + this.name) > -1;
    }

    public int compareTo(Object o) {
        if (o instanceof DestinationInfo) {
            DestinationInfo rhs = (DestinationInfo)o;
            if (rhs.isRemovable() != this.isRemovable()) {
                if (this.isRemovable()) {
                    return -1;
                }
                return 1;
            }
            if (rhs.isViewable() != this.isViewable()) {
                if (this.isViewable()) {
                    return -1;
                }
                return 1;
            }
            return this.name.compareTo(rhs.getName());
        }
        return 1;
    }
}

