/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.jmsmanager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.geronimo.console.BasePortlet;
import org.apache.geronimo.console.databasemanager.DataSourceInfo;
import org.apache.geronimo.console.jmsmanager.activemqCF.ActiveMQConnectorHelper;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.kernel.jmx.JMXUtil;

public class JMSConnectionFactoryManagerPortlet
extends BasePortlet {
    private static final ActiveMQConnectorHelper helper = new ActiveMQConnectorHelper();
    private static final String PARENT_ID = "org/apache/geronimo/SystemJMS";
    private static final String ADD_MODE = "addACF";
    private static final String SUBMIT_CREATE = "Create";
    private final ObjectName DATABASE_QUERY = JMXUtil.getObjectName((String)"*:j2eeType=JCAManagedConnectionFactory,*");
    protected final String NORMAL_VIEW = "/WEB-INF/view/jmsmanager/activemq/normal.jsp";
    protected final String DETAIL_VIEW = "/WEB-INF/view/jmsmanager/activemq/detail.jsp";
    protected final String HELP_VIEW = "/WEB-INF/view/jmsmanager/activemq/help.jsp";
    protected final String ADD_VIEW = "/WEB-INF/view/jmsmanager/activemq/addACF.jsp";
    protected Kernel kernel;
    private PortletRequestDispatcher normalView;
    private PortletRequestDispatcher detailView;
    private PortletRequestDispatcher helpView;
    private PortletRequestDispatcher addView;
    private static final Set HIDDEN_ATTRIBUTES = new HashSet();
    static /* synthetic */ Class class$javax$jms$ConnectionFactory;

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.kernel = KernelRegistry.getSingleKernel();
        PortletContext context = portletConfig.getPortletContext();
        this.normalView = context.getRequestDispatcher("/WEB-INF/view/jmsmanager/activemq/normal.jsp");
        this.detailView = context.getRequestDispatcher("/WEB-INF/view/jmsmanager/activemq/detail.jsp");
        this.helpView = context.getRequestDispatcher("/WEB-INF/view/jmsmanager/activemq/help.jsp");
        this.addView = context.getRequestDispatcher("/WEB-INF/view/jmsmanager/activemq/addACF.jsp");
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String mode = actionRequest.getParameter("mode");
        String submit = actionRequest.getParameter("submit");
        if (mode == null) {
            return;
        }
        if (ADD_MODE.equals(mode)) {
            actionResponse.setRenderParameter("mode", mode);
            if (SUBMIT_CREATE.equals(submit)) {
                String acfName = actionRequest.getParameter("acfName");
                String jndiName = actionRequest.getParameter("jndiName");
                String serverURL = actionRequest.getParameter("serverURL");
                String userName = actionRequest.getParameter("userName");
                String pword = actionRequest.getParameter("pword");
                String poolMaxSize = actionRequest.getParameter("poolMaxSize");
                String blocking = actionRequest.getParameter("blocking");
                Object[] args = new String[]{this.trimStr(acfName), this.trimStr(PARENT_ID), this.trimStr(acfName), this.trimStr(serverURL), this.trimStr(userName), pword, this.trimStr(acfName), this.trimStr(poolMaxSize), this.trimStr(blocking), this.trimStr(jndiName)};
                helper.deployPlan(args);
                actionResponse.setRenderParameter("mode", "list");
            }
            return;
        }
        String name = actionRequest.getParameter("name");
        if (name != null) {
            actionResponse.setRenderParameter("mode", "list");
            return;
        }
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
            return;
        }
        List dependencies = helper.getDependencies();
        renderRequest.setAttribute("dependencies", (Object)dependencies.toArray(new String[dependencies.size()]));
        String name = renderRequest.getParameter("name");
        String mode = renderRequest.getParameter("mode");
        String check = renderRequest.getParameter("check");
        if (ADD_MODE.equals(mode)) {
            this.addView.include(renderRequest, renderResponse);
            return;
        }
        boolean test = false;
        if (name == null || mode == null) {
            mode = "list";
        }
        if ("true".equals(check)) {
            test = true;
        }
        if ("detail".equals(mode) || "config".equals(mode)) {
            this.renderDetail(renderRequest, renderResponse, name);
        } else {
            this.renderList(renderRequest, renderResponse, name, test);
        }
    }

    private void renderList(RenderRequest renderRequest, RenderResponse renderResponse, String name, boolean check) throws PortletException, IOException {
        Set gbeanNames = this.kernel.listGBeans(this.DATABASE_QUERY);
        ArrayList<DataSourceInfo> connectionFactories = new ArrayList<DataSourceInfo>(gbeanNames.size());
        Iterator i = gbeanNames.iterator();
        while (i.hasNext()) {
            ObjectName gbeanName = (ObjectName)i.next();
            try {
                Class<?> cfInterface = Class.forName((String)this.kernel.getAttribute(gbeanName, "connectionFactoryInterface"));
                if (!(class$javax$jms$ConnectionFactory == null ? JMSConnectionFactoryManagerPortlet.class$("javax.jms.ConnectionFactory") : class$javax$jms$ConnectionFactory).isAssignableFrom(cfInterface)) {
                    continue;
                }
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
            DataSourceInfo info = new DataSourceInfo();
            info.setObjectName(gbeanName);
            info.setName(gbeanName.getKeyProperty("name"));
            try {
                info.setJndiName((String)this.kernel.getAttribute(gbeanName, "globalJNDIName"));
                info.setState(new Integer(this.kernel.getGBeanState(gbeanName)));
                if (gbeanName.toString().equals(name) && check) {
                    info.setWorking(true);
                    try {
                        Object cf = this.kernel.invoke(gbeanName, "$getResource");
                        this.testConnection(cf);
                        info.setMessage("Connected");
                    }
                    catch (Exception e) {
                        Throwable t = e;
                        String message = "Failed: ";
                        if (t.getMessage() != null) {
                            message = message + t.getMessage();
                        } else {
                            while (t.getMessage() == null) {
                                if ((t = t.getCause()) != null) {
                                    message = message + t.getMessage();
                                    continue;
                                }
                                message = message + "Unknown reason";
                            }
                        }
                        info.setMessage(message);
                    }
                } else {
                    info.setWorking(false);
                }
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
            connectionFactories.add(info);
        }
        Collections.sort(connectionFactories);
        renderRequest.setAttribute("cFactories", connectionFactories);
        this.normalView.include(renderRequest, renderResponse);
    }

    private void renderDetail(RenderRequest renderRequest, RenderResponse renderResponse, String name) throws PortletException, IOException {
        ObjectName gbeanName;
        try {
            gbeanName = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new PortletException("Malformed parameter name: " + renderRequest.getParameter("name"));
        }
        try {
            GBeanInfo gbeanInfo = this.kernel.getGBeanInfo(gbeanName);
            Set attributes = gbeanInfo.getAttributes();
            HashMap<String, Object> values = new HashMap<String, Object>(attributes.size());
            Iterator i = attributes.iterator();
            while (i.hasNext()) {
                GAttributeInfo attribute = (GAttributeInfo)i.next();
                String gname = attribute.getName();
                if (HIDDEN_ATTRIBUTES.contains(gname)) continue;
                Object value = this.kernel.getAttribute(gbeanName, gname);
                values.put(gname, value);
            }
            renderRequest.setAttribute("attributeMap", values);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        this.detailView.include(renderRequest, renderResponse);
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.helpView.include(renderRequest, renderResponse);
    }

    public void destroy() {
        this.normalView = null;
        this.helpView = null;
        this.addView = null;
        this.kernel = null;
        super.destroy();
    }

    private String trimStr(String str) {
        if (str != null) {
            return str.trim();
        }
        return "";
    }

    protected void testConnection(Object cf) throws Exception {
        ConnectionFactory jmscf = (ConnectionFactory)cf;
        Connection c = jmscf.createConnection();
        c.close();
    }

    static {
        HIDDEN_ATTRIBUTES.add("kernel");
        HIDDEN_ATTRIBUTES.add("connectionImplClass");
        HIDDEN_ATTRIBUTES.add("connectionInterface");
        HIDDEN_ATTRIBUTES.add("connectionFactoryInterface");
        HIDDEN_ATTRIBUTES.add("connectionFactoryImplClass");
        HIDDEN_ATTRIBUTES.add("implementedInterfaces");
        HIDDEN_ATTRIBUTES.add("managedConnectionFactoryClass");
        HIDDEN_ATTRIBUTES.add("recoveryXAResources");
    }
}

