/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.jmsmanager;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.geronimo.console.BasePortlet;
import org.apache.geronimo.console.jmsmanager.handlers.CreateDestinationHandler;
import org.apache.geronimo.console.jmsmanager.handlers.PortletResponseHandler;
import org.apache.geronimo.console.jmsmanager.handlers.RemoveDestinationHandler;
import org.apache.geronimo.console.jmsmanager.handlers.StatisticsHandler;
import org.apache.geronimo.console.jmsmanager.renderers.CreateDestinationRenderer;
import org.apache.geronimo.console.jmsmanager.renderers.PortletRenderer;
import org.apache.geronimo.console.jmsmanager.renderers.StatisticsRenderer;
import org.apache.geronimo.console.jmsmanager.renderers.ViewDLQRenderer;
import org.apache.geronimo.console.jmsmanager.renderers.ViewDestinationsRenderer;
import org.apache.geronimo.console.jmsmanager.renderers.ViewMessagesRenderer;

public class JMSManagerPortlet
extends BasePortlet {
    private PortletRequestDispatcher edit;
    private PortletRequestDispatcher help;
    private ConnectionFactory cf;
    private Map handlers;
    private Map renderers;
    private PortletContext context;

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.context = portletConfig.getPortletContext();
        this.help = this.context.getRequestDispatcher("/WEB-INF/view/jmsmanager/help.jsp");
        this.edit = this.context.getRequestDispatcher("/WEB-INF/view/jmsmanager/edit.jsp");
        this.renderers = new HashMap();
        this.renderers.put("createDestination", new CreateDestinationRenderer());
        this.renderers.put("viewDestinations", new ViewDestinationsRenderer());
        this.renderers.put("statistics", new StatisticsRenderer());
        this.renderers.put("viewMessages", new ViewMessagesRenderer());
        this.renderers.put("viewDLQ", new ViewDLQRenderer());
        this.handlers = new HashMap();
        this.handlers.put("createDestination", new CreateDestinationHandler());
        this.handlers.put("removeDestination", new RemoveDestinationHandler());
        this.handlers.put("statistics", new StatisticsHandler());
    }

    public void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.help.include(renderRequest, renderResponse);
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        PortletRenderer renderer;
        if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
            return;
        }
        String view = renderRequest.getParameter("processAction");
        if (view == null) {
            view = "viewDestinations";
        }
        if ((renderer = (PortletRenderer)this.renderers.get(view)) == null) {
            throw new PortletException("Invalid view parameter specified: " + view);
        }
        String include = renderer.render(renderRequest, renderResponse);
        if (include != null) {
            PortletRequestDispatcher requestDispatcher = this.context.getRequestDispatcher(include);
            requestDispatcher.include(renderRequest, renderResponse);
        }
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String processAction = actionRequest.getParameter("processaction");
        PortletResponseHandler handler = (PortletResponseHandler)this.handlers.get(processAction);
        if (handler == null) {
            handler = (PortletResponseHandler)this.handlers.get("viewDestinations");
        }
        handler.processAction(actionRequest, actionResponse);
    }

    public void destroy() {
        this.help = null;
        this.edit = null;
        super.destroy();
    }
}

