/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.jmsmanager.renderers;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.management.ObjectName;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.activemq.service.DeadLetterPolicy;
import org.apache.geronimo.console.jmsmanager.AbstractJMSManager;
import org.apache.geronimo.console.jmsmanager.renderers.PortletRenderer;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;

public class ViewDLQRenderer
extends AbstractJMSManager
implements PortletRenderer {
    private Destination destination = null;
    private Destination dlq = null;
    private QueueBrowser dlqBrowser = null;
    private Connection connection = null;
    private Session session = null;
    private String dlqName;

    public void setup(RenderRequest request, RenderResponse response) {
        String destinationApplicationName = request.getParameter("destinationApplicationName");
        String destinationModuleName = request.getParameter("destinationModuleName");
        String destinationName = request.getParameter("destinationName");
        try {
            ObjectName adminObjectName = NameFactory.getComponentName(null, null, (String)destinationApplicationName, (String)"JCAResource", (String)destinationModuleName, (String)destinationName, null, (J2eeContext)baseContext);
            this.destination = (Destination)kernel.invoke(adminObjectName, "$getResource");
            ConnectionFactory connectionFactory = (ConnectionFactory)kernel.invoke(ObjectName.getInstance("geronimo.server:J2EEApplication=null,J2EEServer=geronimo,JCAResource=org/apache/geronimo/SystemJMS,j2eeType=JCAManagedConnectionFactory,name=DefaultActiveMQConnectionFactory"), "$getResource");
            this.connection = connectionFactory.createConnection();
            this.session = this.connection.createSession(false, 1);
            DeadLetterPolicy dlp = new DeadLetterPolicy();
            Field f = dlp.getClass().getDeclaredField("deadLetterPerDestinationName");
            f.setAccessible(true);
            boolean deadLetterPerDestinationName = f.getBoolean(dlp);
            f = dlp.getClass().getDeclaredField("deadLetterPrefix");
            f.setAccessible(true);
            String deadLetterPrefix = "" + f.get(dlp);
            this.dlqName = deadLetterPerDestinationName ? deadLetterPrefix + this.destination.getClass().getMethod("getPhysicalName", null).invoke((Object)this.destination, null) : deadLetterPrefix + deadLetterPrefix;
            this.dlq = this.session.createQueue(this.dlqName);
            this.dlqBrowser = this.session.createBrowser((Queue)this.dlq);
            this.connection.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List getDLQContents(QueueBrowser qb) {
        ArrayList list = new ArrayList();
        try {
            Enumeration e = qb.getEnumeration();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                list.add(o);
            }
            this.connection.stop();
            this.dlqBrowser.close();
            this.session.close();
            this.connection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public String render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.setup(request, response);
        List dlqContents = this.getDLQContents(this.dlqBrowser);
        request.setAttribute("dlqcontents", (Object)dlqContents);
        request.setAttribute("dlqname", (Object)this.dlqName);
        return "/WEB-INF/view/jmsmanager/viewDLQ.jsp";
    }
}

