/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.jmsmanager.renderers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.jmsmanager.AbstractJMSManager;
import org.apache.geronimo.console.jmsmanager.DestinationInfo;
import org.apache.geronimo.console.jmsmanager.renderers.PortletRenderer;
import org.apache.geronimo.kernel.DependencyManager;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;

public class ViewDestinationsRenderer
extends AbstractJMSManager
implements PortletRenderer {
    protected static Log log = LogFactory.getLog((Class)ViewDestinationsRenderer.class);

    public String render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        List destinationList = this.getDestinationList(request, response);
        request.setAttribute("destinations", (Object)destinationList);
        return "/WEB-INF/view/jmsmanager/view.jsp";
    }

    public List getDestinationList(RenderRequest request, RenderResponse response) {
        Kernel kernel = KernelRegistry.getSingleKernel();
        Set destinations = kernel.listGBeans(DESTINATION_QUERY);
        ArrayList<DestinationInfo> destinationInfos = new ArrayList<DestinationInfo>(destinations.size());
        DependencyManager dm = kernel.getDependencyManager();
        Iterator iterator = destinations.iterator();
        while (iterator.hasNext()) {
            ObjectName destinationName = (ObjectName)iterator.next();
            try {
                Class type;
                try {
                    type = Class.forName((String)kernel.getAttribute(destinationName, "adminObjectInterface"));
                }
                catch (ClassCastException cce) {
                    type = (Class)kernel.getAttribute(destinationName, "adminObjectInterface");
                }
                Set parents = dm.getParents(destinationName);
                Iterator i = parents.iterator();
                if (!i.hasNext()) continue;
                ObjectName parent = (ObjectName)i.next();
                String adminObjectName = destinationName.getKeyProperty("name");
                if (adminObjectName.equals("MDBTransferBeanOutQueue") || adminObjectName.equals("SendReceiveQueue")) continue;
                String configURI = parent.getKeyProperty("name");
                if (configURI.startsWith("\"")) {
                    configURI = configURI.substring(1);
                }
                if (configURI.endsWith("\"")) {
                    configURI = configURI.substring(0, configURI.length() - 1);
                }
                DestinationInfo info = new DestinationInfo(adminObjectName, (String)kernel.getAttribute(destinationName, "PhysicalName"), type, destinationName.getKeyProperty("J2EEApplication"), destinationName.getKeyProperty("JCAResource"), configURI);
                destinationInfos.add(info);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        Collections.sort(destinationInfos);
        return destinationInfos;
    }
}

