/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.jmsmanager.server;

import java.io.IOException;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.jmsmanager.server.BaseJMSPortlet;
import org.apache.geronimo.console.util.PortletManager;

public class JMSBrokerPortlet
extends BaseJMSPortlet {
    private static final Log log = LogFactory.getLog((Class)JMSBrokerPortlet.class);
    private PortletRequestDispatcher normalView;
    private PortletRequestDispatcher maximizedView;
    private PortletRequestDispatcher helpView;

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        block11: {
            try {
                String mode = actionRequest.getParameter("mode");
                String name = actionRequest.getParameter("objectName");
                if (mode.equals("start")) {
                    try {
                        PortletManager.getManagedBean((PortletRequest)actionRequest, name).startRecursive();
                    }
                    catch (Exception e) {
                        throw new PortletException((Throwable)e);
                    }
                } else if (mode.equals("stop")) {
                    try {
                        PortletManager.getManagedBean((PortletRequest)actionRequest, name).stop();
                    }
                    catch (Exception e) {
                        throw new PortletException((Throwable)e);
                    }
                } else if (mode.equals("edit") || mode.equals("delete") || mode.equals("new")) {
                    // empty if block
                }
                actionResponse.setRenderParameter("mode", "list");
            }
            catch (Throwable e) {
                log.error((Object)"Unable to process portlet action", e);
                if (!(e instanceof PortletException)) break block11;
                throw (PortletException)e;
            }
        }
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        try {
            if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
                return;
            }
            String managerName = PortletManager.getJMSManagerNames((PortletRequest)renderRequest)[0];
            Map map = JMSBrokerPortlet.getBrokerMap(renderRequest, managerName);
            renderRequest.setAttribute("brokers", map.entrySet());
            if (WindowState.NORMAL.equals((Object)renderRequest.getWindowState())) {
                this.normalView.include(renderRequest, renderResponse);
            } else {
                this.maximizedView.include(renderRequest, renderResponse);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Unable to render portlet", e);
        }
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.helpView.include(renderRequest, renderResponse);
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.normalView = portletConfig.getPortletContext().getRequestDispatcher("/WEB-INF/view/jmsmanager/server/normal.jsp");
        this.maximizedView = portletConfig.getPortletContext().getRequestDispatcher("/WEB-INF/view/jmsmanager/server/maximized.jsp");
        this.helpView = portletConfig.getPortletContext().getRequestDispatcher("/WEB-INF/view/jmsmanager/server/help.jsp");
    }

    public void destroy() {
        this.helpView = null;
        this.normalView = null;
        this.maximizedView = null;
        super.destroy();
    }
}

