/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.jmsmanager.server;

import java.io.IOException;
import java.util.ArrayList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.jmsmanager.server.BaseJMSPortlet;
import org.apache.geronimo.console.util.PortletManager;
import org.apache.geronimo.kernel.proxy.GeronimoManagedBean;
import org.apache.geronimo.management.geronimo.JMSConnector;
import org.apache.geronimo.management.geronimo.JMSManager;

public class JMSConnectorPortlet
extends BaseJMSPortlet {
    private static final Log log = LogFactory.getLog((Class)JMSConnectorPortlet.class);
    private PortletRequestDispatcher normalView;
    private PortletRequestDispatcher maximizedView;
    private PortletRequestDispatcher helpView;
    protected PortletRequestDispatcher editView;

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        block17: {
            try {
                String mode = actionRequest.getParameter("mode");
                String managerName = PortletManager.getJMSManagerNames((PortletRequest)actionRequest)[0];
                String brokerName = actionRequest.getParameter("brokerName");
                if (mode.equals("new")) {
                    actionResponse.setRenderParameter("mode", "new");
                    String protocol = actionRequest.getParameter("protocol");
                    actionResponse.setRenderParameter("protocol", protocol);
                    actionResponse.setRenderParameter("brokerName", brokerName);
                    break block17;
                }
                if (mode.equals("add")) {
                    String protocol = actionRequest.getParameter("protocol");
                    String host = actionRequest.getParameter("host");
                    int port = Integer.parseInt(actionRequest.getParameter("port"));
                    String name = actionRequest.getParameter("name");
                    JMSConnector connector = PortletManager.createJMSConnector((PortletRequest)actionRequest, managerName, brokerName, name, protocol, host, port);
                    try {
                        ((GeronimoManagedBean)connector).startRecursive();
                    }
                    catch (Exception e) {
                        log.error((Object)"Unable to start connector", (Throwable)e);
                    }
                    actionResponse.setRenderParameter("mode", "list");
                    break block17;
                }
                if (mode.equals("save")) {
                    String host = actionRequest.getParameter("host");
                    int port = Integer.parseInt(actionRequest.getParameter("port"));
                    String objectName = actionRequest.getParameter("objectName");
                    JMSConnector connector = (JMSConnector)PortletManager.getManagedBean((PortletRequest)actionRequest, objectName);
                    if (connector != null) {
                        connector.setHost(host);
                        connector.setPort(port);
                    }
                    actionResponse.setRenderParameter("mode", "list");
                    break block17;
                }
                if (mode.equals("start")) {
                    String objectName = actionRequest.getParameter("objectName");
                    try {
                        PortletManager.getManagedBean((PortletRequest)actionRequest, objectName).startRecursive();
                    }
                    catch (Exception e) {
                        throw new PortletException((Throwable)e);
                    }
                    actionResponse.setRenderParameter("mode", "list");
                    break block17;
                }
                if (mode.equals("stop")) {
                    String objectName = actionRequest.getParameter("objectName");
                    try {
                        PortletManager.getManagedBean((PortletRequest)actionRequest, objectName).stop();
                    }
                    catch (Exception e) {
                        throw new PortletException((Throwable)e);
                    }
                    actionResponse.setRenderParameter("mode", "list");
                    break block17;
                }
                if (mode.equals("edit")) {
                    String objectName = actionRequest.getParameter("objectName");
                    actionResponse.setRenderParameter("objectName", objectName);
                    actionResponse.setRenderParameter("mode", "edit");
                } else if (mode.equals("delete")) {
                    String objectName = actionRequest.getParameter("objectName");
                    PortletManager.getJMSManager((PortletRequest)actionRequest, managerName).removeConnector(objectName);
                    actionResponse.setRenderParameter("mode", "list");
                }
            }
            catch (Throwable e) {
                log.error((Object)"Unable to process portlet action", e);
                if (!(e instanceof PortletException)) break block17;
                throw (PortletException)e;
            }
        }
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
            return;
        }
        try {
            String mode = renderRequest.getParameter("mode");
            if (mode == null || mode.equals("")) {
                mode = "list";
            }
            String managerName = PortletManager.getJMSManagerNames((PortletRequest)renderRequest)[0];
            if (mode.equals("new")) {
                String brokerName = renderRequest.getParameter("brokerName");
                String protocol = renderRequest.getParameter("protocol");
                renderRequest.setAttribute("protocol", (Object)protocol);
                renderRequest.setAttribute("brokerName", (Object)brokerName);
                renderRequest.setAttribute("mode", (Object)"add");
                this.editView.include(renderRequest, renderResponse);
            } else if (mode.equals("edit")) {
                String objectName = renderRequest.getParameter("objectName");
                JMSConnector connector = (JMSConnector)PortletManager.getManagedBean((PortletRequest)renderRequest, objectName);
                if (connector == null) {
                    this.doList(renderRequest, managerName, renderResponse);
                } else {
                    renderRequest.setAttribute("objectName", (Object)objectName);
                    renderRequest.setAttribute("port", (Object)new Integer(connector.getPort()));
                    renderRequest.setAttribute("host", (Object)connector.getHost());
                    renderRequest.setAttribute("mode", (Object)"save");
                    this.editView.include(renderRequest, renderResponse);
                }
            } else if (mode.equals("list")) {
                this.doList(renderRequest, managerName, renderResponse);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Unable to render portlet", e);
        }
    }

    private void doList(RenderRequest renderRequest, String managerName, RenderResponse renderResponse) throws PortletException, IOException {
        ArrayList<ConnectorWrapper> beans = new ArrayList<ConnectorWrapper>();
        String[] brokerNames = PortletManager.getJMSBrokerNames((PortletRequest)renderRequest, managerName);
        for (int i = 0; i < brokerNames.length; ++i) {
            String brokerName = brokerNames[i];
            try {
                ObjectName bon = ObjectName.getInstance(brokerName);
                JMSConnector[] connectors = PortletManager.getJMSConnectorsForContainer((PortletRequest)renderRequest, managerName, brokerName);
                for (int j = 0; j < connectors.length; ++j) {
                    JMSConnector connector = connectors[j];
                    ObjectName conName = ObjectName.getInstance(((GeronimoManagedBean)connector).getObjectName());
                    String connectorName = conName.getKeyProperty("name");
                    ConnectorWrapper info = new ConnectorWrapper(bon.getKeyProperty("name"), bon.getCanonicalName(), connectorName, connector);
                    beans.add(info);
                }
                continue;
            }
            catch (MalformedObjectNameException e) {
                log.error((Object)"Unable to decode ObjectName", (Throwable)e);
            }
        }
        renderRequest.setAttribute("brokers", JMSConnectorPortlet.getBrokerMap(renderRequest, managerName).entrySet());
        renderRequest.setAttribute("connectors", beans);
        JMSManager mgr = PortletManager.getJMSManager((PortletRequest)renderRequest, managerName);
        renderRequest.setAttribute("protocols", (Object)mgr.getSupportedProtocols());
        if (WindowState.NORMAL.equals((Object)renderRequest.getWindowState())) {
            this.normalView.include(renderRequest, renderResponse);
        } else {
            this.maximizedView.include(renderRequest, renderResponse);
        }
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.helpView.include(renderRequest, renderResponse);
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        PortletContext pc = portletConfig.getPortletContext();
        this.normalView = pc.getRequestDispatcher("/WEB-INF/view/jmsmanager/server/connector/normal.jsp");
        this.maximizedView = pc.getRequestDispatcher("/WEB-INF/view/jmsmanager/server/connector/maximized.jsp");
        this.helpView = pc.getRequestDispatcher("/WEB-INF/view/jmsmanager/server/connector/help.jsp");
        this.editView = pc.getRequestDispatcher("/WEB-INF/view/jmsmanager/server/connector/editGeneric.jsp");
    }

    public void destroy() {
        this.helpView = null;
        this.editView = null;
        this.normalView = null;
        this.maximizedView = null;
        super.destroy();
    }

    public static final boolean isValid(String s) {
        return s != null && !s.equals("");
    }

    public static class ConnectorWrapper {
        private String brokerName;
        private String brokerObjectName;
        private String displayName;
        private JMSConnector connector;

        public ConnectorWrapper(String brokerName, String brokerObjectName, String displayName, JMSConnector connector) {
            this.brokerName = brokerName;
            this.displayName = displayName;
            this.connector = connector;
            this.brokerObjectName = brokerObjectName;
        }

        public String getBrokerName() {
            return this.brokerName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public JMSConnector getConnector() {
            return this.connector;
        }

        public String getBrokerObjectName() {
            return this.brokerObjectName;
        }
    }
}

