/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.jsr77;

import java.io.Serializable;
import java.text.NumberFormat;

public class DynamicServerInfo
implements Serializable {
    private static final long BYTES_MAX = 2048L;
    private static final long KB_MAX = 0x200000L;
    private static final long MB_MAX = 0x80000000L;
    private static final long GB_MAX = 0x20000000000L;
    private static final long TB_MAX = 0x8000000000000L;
    private static final double KB_DIV = 1024.0;
    private static final double MB_DIV = 1048576.0;
    private static final double GB_DIV = 1.073741824E9;
    private static final double TB_DIV = 1.099511627776E12;
    private NumberFormat dec2Format;
    private String memoryCurrent;
    private String memoryMost;
    private String memoryAllocated;
    private String upTime;

    public DynamicServerInfo(long upTime) {
        this.upTime = this.calculateTime(upTime);
        this.memoryMost = "Unknown";
        this.memoryCurrent = "Unknown";
        this.memoryAllocated = "Unknown";
    }

    public DynamicServerInfo(long memoryCurrent, long memoryMost, long memoryAllocated, long upTime) {
        this.dec2Format = NumberFormat.getNumberInstance();
        this.dec2Format.setMaximumFractionDigits(2);
        this.memoryCurrent = this.calculateMemory(memoryCurrent);
        this.memoryMost = this.calculateMemory(memoryMost);
        this.memoryAllocated = this.calculateMemory(memoryAllocated);
        this.upTime = this.calculateTime(upTime);
    }

    private String calculateMemory(long bytes) {
        if (bytes < 2048L) {
            return bytes + " B";
        }
        if (bytes < 0x200000L) {
            return this.dec2Format.format((double)bytes / 1024.0) + " kB";
        }
        if (bytes < 0x80000000L) {
            return this.dec2Format.format((double)bytes / 1048576.0) + " MB";
        }
        if (bytes < 0x20000000000L) {
            return this.dec2Format.format((double)bytes / 1.073741824E9) + " GB";
        }
        if (bytes < 0x8000000000000L) {
            return this.dec2Format.format((double)bytes / 1.099511627776E12) + " TB";
        }
        return "Out of range";
    }

    private String calculateTime(long millis) {
        int secs = (int)(millis / 1000L);
        int days = secs / 86400;
        int hours = (secs %= 86400) / 3600;
        int minutes = (secs %= 3600) / 60;
        secs %= 60;
        StringBuffer buf = new StringBuffer();
        if (days > 1) {
            buf.append(' ').append(days).append(" days");
        } else if (days > 0) {
            buf.append(' ').append(days).append(" day");
        }
        if (hours > 1) {
            buf.append(' ').append(hours).append(" hours");
        } else if (hours > 0) {
            buf.append(' ').append(hours).append(" hour");
        }
        if (minutes > 1) {
            buf.append(' ').append(minutes).append(" minutes");
        } else if (minutes > 0) {
            buf.append(' ').append(minutes).append(" minute");
        }
        if (secs > 1) {
            buf.append(' ').append(secs).append(" seconds");
        } else if (secs > 0) {
            buf.append(' ').append(secs).append(" second");
        }
        buf.delete(0, 1);
        return buf.toString();
    }

    public String getMemoryCurrent() {
        return this.memoryCurrent;
    }

    public String getMemoryMost() {
        return this.memoryMost;
    }

    public String getMemoryAllocated() {
        return this.memoryAllocated;
    }

    public String getUpTime() {
        return this.upTime;
    }
}

