/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.logmanager;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.geronimo.console.BasePortlet;
import org.apache.geronimo.console.util.PortletManager;
import org.apache.geronimo.system.logging.SystemLog;

public class LogManagerPortlet
extends BasePortlet {
    protected PortletRequestDispatcher normalView;
    protected PortletRequestDispatcher helpView;

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderRespose) throws PortletException, IOException {
        this.helpView.include(renderRequest, renderRespose);
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderRespose) throws PortletException, IOException {
        if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
            return;
        }
        SystemLog log = PortletManager.getCurrentSystemLog((PortletRequest)renderRequest);
        renderRequest.setAttribute("configFile", (Object)log.getConfigFileName());
        renderRequest.setAttribute("logLevel", (Object)log.getRootLoggerLevel());
        renderRequest.setAttribute("refreshPeriod", (Object)new Integer(log.getRefreshPeriodSeconds()));
        this.normalView.include(renderRequest, renderRespose);
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        PortletContext pc = portletConfig.getPortletContext();
        this.normalView = pc.getRequestDispatcher("/WEB-INF/view/logmanager/view.jsp");
        this.helpView = pc.getRequestDispatcher("/WEB-INF/view/logmanager/help.jsp");
        super.init(portletConfig);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        SystemLog log = PortletManager.getCurrentSystemLog((PortletRequest)actionRequest);
        String action = actionRequest.getParameter("action");
        String logLevel = actionRequest.getParameter("logLevel");
        String configFile = actionRequest.getParameter("configFile");
        String configuration = actionRequest.getParameter("append");
        String refreshPeriod = actionRequest.getParameter("refreshPeriod");
        String currentLevel = log.getRootLoggerLevel();
        if ("update".equals(action)) {
            int refreshPeriodInt;
            if (refreshPeriod != null && (refreshPeriodInt = Integer.parseInt(refreshPeriod)) != log.getRefreshPeriodSeconds()) {
                log.setRefreshPeriodSeconds(refreshPeriodInt);
            }
            if (!log.getConfigFileName().equals(configFile)) {
                log.setConfigFileName(configFile);
            }
            if (!currentLevel.equals(logLevel)) {
                log.setRootLoggerLevel(logLevel);
            }
        }
    }
}

