/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.logmanager;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.geronimo.console.BasePortlet;
import org.apache.geronimo.console.util.PortletManager;
import org.apache.geronimo.system.logging.SystemLog;

public class LogViewerPortlet
extends BasePortlet {
    private static final String CRITERIA_KEY = "org.apache.geronimo.console.log.CRITERIA";
    protected PortletRequestDispatcher searchView;
    protected PortletRequestDispatcher helpView;

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderRespose) throws PortletException, IOException {
        this.helpView.include(renderRequest, renderRespose);
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderRespose) throws PortletException, IOException {
        Criteria criteria;
        if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
            return;
        }
        String action = renderRequest.getParameter("action");
        SystemLog log = PortletManager.getCurrentSystemLog((PortletRequest)renderRequest);
        String[] logFiles = log.getLogFileNames();
        LogFile[] files = new LogFile[logFiles.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new LogFile(logFiles[i]);
        }
        if ("refresh".equals(action)) {
            criteria = (Criteria)renderRequest.getPortletSession(true).getAttribute(CRITERIA_KEY, 2);
        } else {
            String startPos = renderRequest.getParameter("startPos");
            String endPos = renderRequest.getParameter("endPos");
            String maxRows = renderRequest.getParameter("maxRows");
            String logLevel = renderRequest.getParameter("logLevel");
            String searchString = renderRequest.getParameter("searchString");
            String stackTraces = renderRequest.getParameter("stackTraces");
            String logFile = renderRequest.getParameter("logFile");
            if (logFile == null || logFile.equals("")) {
                logFile = logFiles[0];
            }
            if (logLevel == null || logLevel.equals("")) {
                logLevel = "WARN";
            }
            if (maxRows == null || maxRows.equals("")) {
                maxRows = "10";
            }
            criteria = new Criteria();
            criteria.max = Integer.parseInt(maxRows);
            criteria.start = startPos == null || startPos.equals("") ? null : new Integer(startPos);
            criteria.stop = endPos == null || endPos.equals("") ? null : new Integer(endPos);
            criteria.logFile = logFile;
            criteria.stackTraces = stackTraces != null && !stackTraces.equals("");
            criteria.level = logLevel;
            criteria.text = searchString == null || searchString.equals("") ? null : searchString;
            renderRequest.getPortletSession(true).setAttribute(CRITERIA_KEY, (Object)criteria, 2);
        }
        SystemLog.SearchResults results = log.getMatchingItems(criteria.logFile, criteria.start, criteria.stop, criteria.level, criteria.text, criteria.max, criteria.stackTraces);
        renderRequest.setAttribute("searchResults", (Object)results.getResults());
        renderRequest.setAttribute("lineCount", (Object)new Integer(results.getLineCount()));
        renderRequest.setAttribute("startPos", (Object)criteria.start);
        renderRequest.setAttribute("endPos", (Object)criteria.stop);
        renderRequest.setAttribute("logLevel", (Object)criteria.level);
        renderRequest.setAttribute("searchString", (Object)criteria.text);
        renderRequest.setAttribute("maxRows", (Object)Integer.toString(criteria.max));
        renderRequest.setAttribute("logFile", (Object)criteria.logFile);
        renderRequest.setAttribute("logFiles", (Object)files);
        if (criteria.stackTraces) {
            renderRequest.setAttribute("stackTraces", (Object)Boolean.TRUE);
        }
        if (results.isCapped()) {
            renderRequest.setAttribute("capped", (Object)Boolean.TRUE);
        }
        this.searchView.include(renderRequest, renderRespose);
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        PortletContext pc = portletConfig.getPortletContext();
        this.searchView = pc.getRequestDispatcher("/WEB-INF/view/logmanager/search.jsp");
        this.helpView = pc.getRequestDispatcher("/WEB-INF/view/logmanager/viewhelp.jsp");
        super.init(portletConfig);
    }

    public static class LogFile {
        private String fullName;
        private String name;

        public LogFile(String fullName) {
            this.fullName = fullName;
            int pos = fullName.lastIndexOf(File.separatorChar);
            this.name = pos > -1 ? fullName.substring(pos + 1) : fullName;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class Criteria
    implements Serializable {
        int max;
        Integer start;
        Integer stop;
        String text;
        String level;
        String logFile;
        boolean stackTraces;

        private Criteria() {
        }
    }
}

