/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.logmanager;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.console.logmanager.WebAccessLogCriteria;
import org.apache.geronimo.console.util.KernelHelper;

public class WebAccessLogHelper
extends KernelHelper {
    private static ObjectName objName;
    private static ObjectName serverInfoObjName;
    private static final String LOG_FILE_ATTR = "filename";
    private static Map logs;
    private static boolean loaded;
    private static int lines;

    private static Map loadLogs() throws IOException {
        if (!loaded) {
            WebAccessLogHelper.refresh();
        }
        return logs;
    }

    public static ArrayList getLogsByDate(Date logDate) throws IOException {
        return WebAccessLogHelper.filterLogsByDate(WebAccessLogCriteria.getGlobalMatcher(), logDate, logDate);
    }

    public static int getLineCount() throws IOException {
        if (!loaded) {
            WebAccessLogHelper.refresh();
        }
        return lines;
    }

    public static ArrayList getLogs() throws IOException {
        return WebAccessLogHelper.filterLogs(WebAccessLogCriteria.getGlobalMatcher());
    }

    public static ArrayList filterLogs(WebAccessLogCriteria criteria) throws IOException {
        Map log = WebAccessLogHelper.loadLogs();
        ArrayList<WebAccessLogCriteria> ret = new ArrayList<WebAccessLogCriteria>();
        Iterator i = log.keySet().iterator();
        while (i.hasNext()) {
            Date date = (Date)i.next();
            ArrayList msgs = (ArrayList)log.get(date);
            Iterator j = msgs.iterator();
            while (j.hasNext()) {
                WebAccessLogCriteria obj = (WebAccessLogCriteria)j.next();
                if (!obj.matches(criteria)) continue;
                ret.add(obj);
            }
        }
        return ret;
    }

    public static ArrayList filterLogsByDate(WebAccessLogCriteria criteria, Date startDate, Date endDate) throws IOException {
        Map log = WebAccessLogHelper.loadLogs();
        ArrayList<WebAccessLogCriteria> ret = new ArrayList<WebAccessLogCriteria>();
        Iterator i = log.keySet().iterator();
        while (i.hasNext()) {
            Date date = (Date)i.next();
            ArrayList msgs = (ArrayList)log.get(date);
            Iterator j = msgs.iterator();
            while (j.hasNext()) {
                WebAccessLogCriteria obj = (WebAccessLogCriteria)j.next();
                if (!obj.matches(criteria) || !WebAccessLogHelper.isBetween(date, startDate, endDate)) continue;
                ret.add(obj);
            }
        }
        return ret;
    }

    public static ArrayList searchLogs(String requestHost, String authUser, String requestMethod, String requestedURI) throws IOException {
        return WebAccessLogHelper.searchLogs(requestHost, authUser, requestMethod, requestedURI, null, null);
    }

    public static ArrayList searchLogs(String requestHost, String authUser, String requestMethod, String requestedURI, Date startDate, Date endDate) throws IOException {
        if (requestHost != null && requestHost.trim().length() == 0) {
            requestHost = null;
        }
        if (authUser != null && authUser.trim().length() == 0) {
            authUser = null;
        }
        if (requestMethod != null && requestMethod.trim().length() == 0) {
            requestMethod = null;
        }
        if (requestedURI != null && requestedURI.trim().length() == 0) {
            requestedURI = null;
        }
        WebAccessLogCriteria criteria = new WebAccessLogCriteria("", requestHost, authUser, requestMethod, requestedURI);
        if (startDate == null || endDate == null) {
            return WebAccessLogHelper.filterLogs(criteria);
        }
        return WebAccessLogHelper.filterLogsByDate(criteria, startDate, endDate);
    }

    public static File[] getFiles() {
        String fileNamePattern = WebAccessLogHelper.get(objName, LOG_FILE_ATTR).toString();
        if (fileNamePattern.indexOf("/") > -1) {
            fileNamePattern = fileNamePattern.substring(fileNamePattern.lastIndexOf("/") + 1);
        } else if (fileNamePattern.indexOf("\\") > -1) {
            fileNamePattern = fileNamePattern.substring(fileNamePattern.lastIndexOf("\\") + 1);
        }
        Object[] arg = new Object[]{WebAccessLogHelper.get(objName, LOG_FILE_ATTR).toString()};
        String[] parms = new String[]{String.class.getName()};
        try {
            String logFile = (String)WebAccessLogHelper.invoke(serverInfoObjName, "resolvePath", arg, parms);
            File f = new File(logFile).getParentFile();
            return f != null ? f.listFiles(new PatternFilenameFilter(fileNamePattern)) : new File[]{};
        }
        catch (Exception e) {
            return new File[0];
        }
    }

    public static void refresh() throws IOException {
        loaded = false;
        lines = 0;
        logs.clear();
        File[] logFiles = WebAccessLogHelper.getFiles();
        for (int i = 0; i < logFiles.length; ++i) {
            BufferedReader in = new BufferedReader(new FileReader(logFiles[i]));
            String line = in.readLine();
            while (line != null) {
                try {
                    StringTokenizer split = new StringTokenizer(line, " ");
                    String remoteHost = split.nextToken().trim();
                    split.nextToken();
                    String user = split.nextToken("[").trim();
                    String dateTime = split.nextToken(" ").substring(1).trim();
                    split.nextToken();
                    String reqMethod = split.nextToken().substring(1).trim();
                    String reqURI = split.nextToken().trim();
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss").parse(dateTime));
                    calendar.clear(14);
                    calendar.clear(12);
                    calendar.clear(13);
                    calendar.clear(11);
                    calendar.clear(10);
                    ArrayList msgs = logs.containsKey(calendar.getTime()) ? (ArrayList)logs.get(calendar.getTime()) : new ArrayList();
                    WebAccessLogCriteria criteria = new WebAccessLogCriteria(line, remoteHost, user, reqMethod, reqURI);
                    msgs.add(0, criteria);
                    logs.put(calendar.getTime(), msgs);
                    ++lines;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                line = in.readLine();
            }
        }
        loaded = true;
    }

    private static boolean isBetween(Date date, Date startDate, Date endDate) {
        return !(!date.equals(startDate) && !date.after(startDate) || !date.equals(endDate) && !date.before(endDate));
    }

    static {
        logs = new TreeMap();
        loaded = false;
        lines = 0;
        try {
            objName = new ObjectName("geronimo.server:J2EEApplication=null,J2EEModule=org/apache/geronimo/Jetty,J2EEServer=geronimo,j2eeType=GBean,name=JettyRequestLog");
            serverInfoObjName = new ObjectName("geronimo.server:name=ServerInfo,J2EEServer=geronimo,J2EEApplication=null,j2eeType=GBean,J2EEModule=org/apache/geronimo/System");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }

    static class PatternFilenameFilter
    implements FilenameFilter {
        Pattern pattern;

        PatternFilenameFilter(String fileNamePattern) {
            fileNamePattern = fileNamePattern.replaceAll("yyyy", "\\\\d{4}");
            fileNamePattern = fileNamePattern.replaceAll("yy", "\\\\d{2}");
            fileNamePattern = fileNamePattern.replaceAll("mm", "\\\\d{2}");
            fileNamePattern = fileNamePattern.replaceAll("dd", "\\\\d{2}") + ".*";
            this.pattern = Pattern.compile(fileNamePattern);
        }

        public boolean accept(File file, String fileName) {
            return this.pattern.matcher(fileName).matches();
        }
    }
}

