/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.logmanager;

import java.io.IOException;
import java.util.Calendar;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.BasePortlet;
import org.apache.geronimo.console.util.PortletManager;
import org.apache.geronimo.management.geronimo.WebAccessLog;

public class WebAccessLogViewerPortlet
extends BasePortlet {
    private static final Log log = LogFactory.getLog((Class)WebAccessLogViewerPortlet.class);
    protected PortletRequestDispatcher searchView;
    protected PortletRequestDispatcher helpView;

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderRespose) throws PortletException, IOException {
        this.helpView.include(renderRequest, renderRespose);
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderRespose) throws PortletException, IOException {
        if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
            return;
        }
        String[] names = PortletManager.getWebManagerNames((PortletRequest)renderRequest);
        if (names != null) {
            String managerName = names[0];
            String[] containers = PortletManager.getWebContainerNames((PortletRequest)renderRequest, managerName);
            if (containers != null) {
                String containerName = containers[0];
                WebAccessLog log = PortletManager.getWebAccessLog((PortletRequest)renderRequest, managerName, containerName);
                String action = renderRequest.getParameter("action");
                if ("refresh".equals(action)) {
                    // empty if block
                }
                String startDate = renderRequest.getParameter("startDate");
                String startMonth = renderRequest.getParameter("startMonth");
                String startYear = renderRequest.getParameter("startYear");
                String endDate = renderRequest.getParameter("endDate");
                String endMonth = renderRequest.getParameter("endMonth");
                String endYear = renderRequest.getParameter("endYear");
                Calendar cal1 = Calendar.getInstance();
                Calendar cal2 = Calendar.getInstance();
                if (startDate == null || startMonth == null || startYear == null || endDate == null || endMonth == null || endYear == null) {
                    cal1.set(14, 0);
                    cal1.set(12, 0);
                    cal1.set(13, 0);
                    cal1.clear(11);
                    cal2.setTime(cal1.getTime());
                    cal2.add(6, 1);
                    WebAccessLog.SearchResults matchingItems = log.getMatchingItems(log.getLogFileNames()[0], null, null, null, null, cal1.getTime(), cal2.getTime(), null, null);
                    renderRequest.setAttribute("logs", (Object)matchingItems.getResults());
                    renderRequest.setAttribute("logLength", (Object)new Integer(matchingItems.getLineCount()));
                } else {
                    int sdt = Integer.parseInt(startDate);
                    int smnth = Integer.parseInt(startMonth);
                    int syr = Integer.parseInt(startYear);
                    int edt = Integer.parseInt(endDate);
                    int emnth = Integer.parseInt(endMonth);
                    int eyr = Integer.parseInt(endYear);
                    boolean ignoreDates = renderRequest.getParameter("ignoreDates") == null;
                    String requestHost = renderRequest.getParameter("requestHost");
                    String authUser = renderRequest.getParameter("authUser");
                    String requestMethod = renderRequest.getParameter("requestMethod");
                    String requestedURI = renderRequest.getParameter("requestedURI");
                    if (ignoreDates) {
                        cal1.clear();
                        cal2.clear();
                        cal1.set(5, sdt);
                        cal1.set(2, smnth);
                        cal1.set(1, syr);
                        cal2.set(5, edt);
                        cal2.set(2, emnth);
                        cal2.set(1, eyr);
                        WebAccessLog.SearchResults matchingItems = log.getMatchingItems(log.getLogFileNames()[0], requestHost, authUser, requestMethod, requestedURI, cal1.getTime(), cal2.getTime(), null, null);
                        renderRequest.setAttribute("logs", (Object)matchingItems.getResults());
                        renderRequest.setAttribute("logLength", (Object)new Integer(matchingItems.getLineCount()));
                    } else {
                        WebAccessLog.SearchResults matchingItems = log.getMatchingItems(log.getLogFileNames()[0], requestHost, authUser, requestMethod, requestedURI, null, null, null, null);
                        renderRequest.setAttribute("logs", (Object)matchingItems.getResults());
                        renderRequest.setAttribute("logLength", (Object)new Integer(matchingItems.getLineCount()));
                    }
                    renderRequest.setAttribute("ignoreDates", (Object)new Boolean(ignoreDates));
                    renderRequest.setAttribute("requestHost", (Object)requestHost);
                    renderRequest.setAttribute("authUser", (Object)authUser);
                    renderRequest.setAttribute("requestMethod", (Object)requestMethod);
                    renderRequest.setAttribute("requestedURI", (Object)requestedURI);
                }
                renderRequest.setAttribute("toDate", (Object)cal2.getTime());
                renderRequest.setAttribute("fromDate", (Object)cal1.getTime());
                this.searchView.include(renderRequest, renderRespose);
            } else {
                log.error((Object)"No web containers found");
            }
        } else {
            log.error((Object)"No web managers found");
        }
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        PortletContext pc = portletConfig.getPortletContext();
        this.searchView = pc.getRequestDispatcher("/WEB-INF/view/webaccesslogmanager/view.jsp");
        this.helpView = pc.getRequestDispatcher("/WEB-INF/view/webaccesslogmanager/help.jsp");
        super.init(portletConfig);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
    }
}

