/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.repository;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.geronimo.console.BasePortlet;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;

public class RepositoryViewPortlet
extends BasePortlet {
    private static final String REPO_OBJ_NAME = "geronimo.server:name=Repository,J2EEServer=geronimo,J2EEApplication=null,j2eeType=GBean,J2EEModule=org/apache/geronimo/System";
    private Kernel kernel;
    private PortletContext ctx;
    private PortletRequestDispatcher normalView;
    private PortletRequestDispatcher helpView;
    private URL rootURL;

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.kernel = KernelRegistry.getSingleKernel();
        this.ctx = portletConfig.getPortletContext();
        this.normalView = this.ctx.getRequestDispatcher("/WEB-INF/view/repository/normal.jsp");
        this.helpView = this.ctx.getRequestDispatcher("/WEB-INF/view/repository/help.jsp");
        URI uri = null;
        try {
            ObjectName reponame = new ObjectName(REPO_OBJ_NAME);
            uri = new URI(".");
            this.rootURL = (URL)this.kernel.invoke(reponame, "getURL", new Object[]{uri}, new String[]{"java.net.URI"});
            uri = new URI(this.rootURL.toString());
            this.rootURL.getFile();
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        if (!uri.getScheme().equals("file")) {
            throw new PortletException("unsupported scheme: repositoryURL = " + this.rootURL.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        File rootDir = new File(this.rootURL.getFile() + File.separatorChar + "upload" + File.separatorChar + "jars");
        if (!rootDir.exists()) {
            rootDir.mkdirs();
        }
        PortletFileUpload uploader = new PortletFileUpload((FileItemFactory)new DiskFileItemFactory(10240, rootDir));
        File uploadFile = null;
        try {
            List items = uploader.parseRequest(actionRequest);
            Iterator i = items.iterator();
            while (i.hasNext()) {
                File file;
                FileItem item = (FileItem)i.next();
                if (item.isFormField()) continue;
                String fieldName = item.getFieldName().trim();
                String name = item.getName().trim();
                if (name.length() == 0) {
                    file = null;
                } else {
                    int index = name.lastIndexOf(92);
                    if (index != -1) {
                        name = name.substring(index + 1);
                    }
                    file = new File(rootDir, name);
                }
                if ("local".equals(fieldName)) {
                    uploadFile = file;
                }
                if (file == null) continue;
                try {
                    item.write(file);
                }
                catch (Exception e) {
                    throw new PortletException((Throwable)e);
                    return;
                }
            }
        }
        catch (FileUploadException e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (WindowState.MINIMIZED.equals((Object)request.getWindowState())) {
            return;
        }
        try {
            File f = new File(new URI(this.rootURL.toString()));
            List ls = this.listing(f, f.getCanonicalPath());
            Collections.sort(ls);
            request.setAttribute("org.apache.geronimo.console.repo.root", (Object)this.rootURL.toString());
            request.setAttribute("org.apache.geronimo.console.repo.list", (Object)ls);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        this.normalView.include(request, response);
    }

    public void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.helpView.include(request, response);
    }

    public List listing(File dir, String basepath) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("directory argument is null");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("directory argument expected");
        }
        ArrayList<String> listing = new ArrayList<String>();
        List<File> ls = Arrays.asList(dir.listFiles());
        Iterator<File> iter = ls.iterator();
        while (iter.hasNext()) {
            File f = iter.next();
            if (f.isDirectory()) {
                List listing1 = this.listing(f, basepath);
                listing.addAll(listing1);
                continue;
            }
            listing.add(f.getCanonicalPath().substring(basepath.length() + 1));
        }
        return listing;
    }
}

