/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.securitymanager;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.geronimo.console.securitymanager.AbstractSecurityManagerPortlet;
import org.apache.geronimo.console.util.SERealmGroupHelper;
import org.apache.geronimo.console.util.SERealmUserHelper;

public class SEGroupsPortlet
extends AbstractSecurityManagerPortlet {
    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
            return;
        }
        String errorMessage = renderRequest.getParameter("errorMessage");
        if (errorMessage != null) {
            renderRequest.setAttribute("errorMessage", (Object)errorMessage);
            this.errorView.include(renderRequest, renderResponse);
        } else {
            String currAction = renderRequest.getParameter("currAction");
            String message = renderRequest.getParameter("message");
            renderRequest.setAttribute("message", (Object)message);
            try {
                if ("new".equals(currAction)) {
                    renderRequest.setAttribute("users", (Object)SERealmUserHelper.getUsers());
                    this.addMaximizedView.include(renderRequest, renderResponse);
                } else if ("edit".equals(currAction)) {
                    String group = renderRequest.getParameter("group");
                    renderRequest.setAttribute("group", (Object)group);
                    renderRequest.setAttribute("users", (Object)SERealmUserHelper.getUsers());
                    this.addMaximizedView.include(renderRequest, renderResponse);
                } else {
                    String[] groups = SERealmGroupHelper.getGroups();
                    Hashtable<String, Set> groupsInfo = new Hashtable<String, Set>();
                    for (int i = 0; i < groups.length; ++i) {
                        String currentGroup = groups[i];
                        groupsInfo.put(currentGroup, SERealmGroupHelper.getUsers(currentGroup));
                    }
                    renderRequest.setAttribute("groupsInfo", groupsInfo);
                    if (WindowState.NORMAL.equals((Object)renderRequest.getWindowState())) {
                        this.normalView.include(renderRequest, renderResponse);
                    } else {
                        this.maximizedView.include(renderRequest, renderResponse);
                    }
                }
            }
            catch (Exception e) {
                errorMessage = e.getMessage();
                renderRequest.setAttribute("errorMessage", (Object)errorMessage);
                this.errorView.include(renderRequest, renderResponse);
            }
        }
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        PortletContext pc = portletConfig.getPortletContext();
        this.normalView = pc.getRequestDispatcher("/WEB-INF/view/securityrealmmanager/se/groups/normal.jsp");
        this.addNormalView = pc.getRequestDispatcher("/WEB-INF/view/securityrealmmanager/se/groups/addnormal.jsp");
        this.maximizedView = pc.getRequestDispatcher("/WEB-INF/view/securityrealmmanager/se/groups/maximized.jsp");
        this.addMaximizedView = pc.getRequestDispatcher("/WEB-INF/view/securityrealmmanager/se/groups/addmaximized.jsp");
        this.helpView = pc.getRequestDispatcher("/WEB-INF/view/securityrealmmanager/se/groups/help.jsp");
        this.errorView = pc.getRequestDispatcher("/WEB-INF/view/securityrealmmanager/se/groups/error.jsp");
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String action = actionRequest.getParameter("action").trim();
        String cancel = actionRequest.getParameter("cancel");
        String currAction = "";
        if (cancel != null) {
            action = "";
        }
        String group = actionRequest.getParameter("group");
        String[] users = actionRequest.getParameterValues("users");
        try {
            if ("delete".equals(action)) {
                SERealmGroupHelper.deleteGroup(group);
            } else if ("update".equals(action)) {
                SERealmGroupHelper.updateGroup(group, users);
            } else if ("add".equals(action)) {
                try {
                    SERealmGroupHelper.addGroup(group, users);
                }
                catch (Exception e) {
                    actionResponse.setRenderParameter("message", "ERROR: Group already exists");
                }
            } else if ("new".equals(action)) {
                currAction = "new";
            } else if ("edit".equals(action)) {
                currAction = "edit";
            }
            actionResponse.setRenderParameter("currAction", currAction);
            if (group != null) {
                actionResponse.setRenderParameter("group", group);
            }
        }
        catch (Exception e) {
            actionResponse.setRenderParameter("errorMessage", "Error encountered in DerbyGroupsPortlet: " + e.getMessage());
        }
    }
}

