/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.securitymanager;

import java.io.IOException;
import java.util.Hashtable;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.geronimo.console.securitymanager.AbstractSecurityManagerPortlet;
import org.apache.geronimo.console.util.SERealmUserHelper;

public class SEUsersPortlet
extends AbstractSecurityManagerPortlet {
    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
            return;
        }
        String errorMessage = renderRequest.getParameter("errorMessage");
        if (errorMessage != null) {
            renderRequest.setAttribute("errorMessage", (Object)errorMessage);
            this.errorView.include(renderRequest, renderResponse);
        } else {
            try {
                String[] users = SERealmUserHelper.getUsers();
                Hashtable<String, String> userInfo = new Hashtable<String, String>();
                for (int i = 0; i < users.length; ++i) {
                    String currentUser = users[i];
                    userInfo.put(currentUser, SERealmUserHelper.getPassword(currentUser.toString()));
                }
                String currAction = renderRequest.getParameter("currAction");
                renderRequest.setAttribute("message", (Object)renderRequest.getParameter("message"));
                if ("new".equals(currAction) || "edit".equals(currAction)) {
                    if (currAction.equals("edit")) {
                        String user = renderRequest.getParameter("user");
                        renderRequest.setAttribute("userID", (Object)user);
                        renderRequest.setAttribute("password", (Object)SERealmUserHelper.getPassword(user));
                    }
                    this.addMaximizedView.include(renderRequest, renderResponse);
                } else if (WindowState.NORMAL.equals((Object)renderRequest.getWindowState())) {
                    renderRequest.setAttribute("userInfo", userInfo);
                    this.normalView.include(renderRequest, renderResponse);
                } else {
                    renderRequest.setAttribute("userInfo", userInfo);
                    this.maximizedView.include(renderRequest, renderResponse);
                }
            }
            catch (Exception e) {
                errorMessage = e.getMessage();
                renderRequest.setAttribute("errorMessage", (Object)errorMessage);
                this.errorView.include(renderRequest, renderResponse);
            }
        }
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        PortletContext pc = portletConfig.getPortletContext();
        this.normalView = pc.getRequestDispatcher("/WEB-INF/view/securityrealmmanager/se/users/normal.jsp");
        this.addNormalView = pc.getRequestDispatcher("/WEB-INF/view/securityrealmmanager/se/users/addnormal.jsp");
        this.maximizedView = pc.getRequestDispatcher("/WEB-INF/view/securityrealmmanager/se/users/maximized.jsp");
        this.addMaximizedView = pc.getRequestDispatcher("/WEB-INF/view/securityrealmmanager/se/users/addmaximized.jsp");
        this.helpView = pc.getRequestDispatcher("/WEB-INF/view/securityrealmmanager/se/users/help.jsp");
        this.errorView = pc.getRequestDispatcher("/WEB-INF/view/securityrealmmanager/derby/groups/error.jsp");
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String action = actionRequest.getParameter("action").trim();
        String cancel = actionRequest.getParameter("cancel");
        String currAction = "";
        if (cancel != null) {
            action = "";
        }
        String user = actionRequest.getParameter("userId");
        String password = actionRequest.getParameter("password");
        try {
            if ("delete".equals(action)) {
                SERealmUserHelper.deleteUser(user);
            } else if ("update".equals(action)) {
                SERealmUserHelper.updateUser(user, password);
            } else if ("add".equals(action)) {
                try {
                    SERealmUserHelper.addUser(user, password);
                }
                catch (Exception e) {
                    actionResponse.setRenderParameter("message", "ERROR: User already exists");
                }
            } else if ("new".equals(action)) {
                currAction = "new";
            } else if ("edit".equals(action)) {
                currAction = "edit";
            }
            actionResponse.setRenderParameter("currAction", currAction);
            if (user != null) {
                actionResponse.setRenderParameter("user", user);
            }
        }
        catch (Exception e) {
            actionResponse.setRenderParameter("errorMessage", "Error encountered in DerbyGroupsPortlet: " + e.getMessage());
        }
    }
}

