/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.servermanager;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.BasePortlet;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.system.main.Daemon;

public class ServerManagerPortlet
extends BasePortlet {
    private static final Log log = LogFactory.getLog((String)"ServerManager");
    private PortletRequestDispatcher normalView;
    private PortletRequestDispatcher shutdownView;
    private PortletRequestDispatcher helpView;
    private Kernel kernel;

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        if (actionRequest.getParameter("reboot") != null) {
            log.info((Object)("Reboot initiated by user request: " + actionRequest.getUserPrincipal()));
            new Thread(){

                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ServerManagerPortlet.this.kernel.shutdown();
                    Daemon.main((String[])new String[0]);
                }
            }.start();
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (request.getParameter("shutdown") != null) {
            log.info((Object)("Shutting down by user request: " + request.getUserPrincipal()));
            this.shutdownView.include(request, response);
            response.flushBuffer();
            this.kernel.shutdown();
            System.exit(0);
        } else {
            this.normalView.include(request, response);
        }
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.helpView.include(renderRequest, renderResponse);
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.normalView = portletConfig.getPortletContext().getRequestDispatcher("/WEB-INF/view/servermanager/normal.jsp");
        this.shutdownView = portletConfig.getPortletContext().getRequestDispatcher("/WEB-INF/view/servermanager/shutdown.jsp");
        this.helpView = portletConfig.getPortletContext().getRequestDispatcher("/WEB-INF/view/servermanager/help.jsp");
        this.kernel = KernelRegistry.getSingleKernel();
    }

    public void destroy() {
        this.normalView = null;
        this.shutdownView = null;
        this.helpView = null;
        super.destroy();
    }
}

