/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.util;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.util.KernelManagementHelper;
import org.apache.geronimo.console.util.ManagementHelper;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.kernel.proxy.GeronimoManagedBean;
import org.apache.geronimo.management.J2EEDomain;
import org.apache.geronimo.management.geronimo.EJBManager;
import org.apache.geronimo.management.geronimo.J2EEServer;
import org.apache.geronimo.management.geronimo.JMSBroker;
import org.apache.geronimo.management.geronimo.JMSConnector;
import org.apache.geronimo.management.geronimo.JMSManager;
import org.apache.geronimo.management.geronimo.JVM;
import org.apache.geronimo.management.geronimo.WebAccessLog;
import org.apache.geronimo.management.geronimo.WebConnector;
import org.apache.geronimo.management.geronimo.WebContainer;
import org.apache.geronimo.management.geronimo.WebManager;
import org.apache.geronimo.pool.GeronimoExecutor;
import org.apache.geronimo.system.logging.SystemLog;

public class PortletManager {
    private static final Log log = LogFactory.getLog((Class)PortletManager.class);
    private static final String HELPER_KEY = "org.apache.geronimo.console.ManagementHelper";
    private static final String DOMAIN_KEY = "org.apache.geronimo.console.J2EEDomain";
    private static final String SERVER_KEY = "org.apache.geronimo.console.J2EEServer";
    private static final String JVM_KEY = "org.apache.geronimo.console.JVM";
    private static final String SYSTEM_LOG_KEY = "org.apache.geronimo.console.SystemLog";

    private static ManagementHelper createHelper() {
        Kernel kernel = null;
        try {
            kernel = (Kernel)new InitialContext().lookup("java:comp/GeronimoKernel");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (kernel == null) {
            log.debug((Object)"Unable to find kernel in JNDI; using KernelRegistry instead");
            kernel = KernelRegistry.getSingleKernel();
        }
        return new KernelManagementHelper(kernel);
    }

    public static ManagementHelper getManagementHelper(PortletRequest request) {
        ManagementHelper helper = (ManagementHelper)request.getPortletSession(true).getAttribute(HELPER_KEY, 1);
        if (helper == null) {
            helper = PortletManager.createHelper();
            request.getPortletSession().setAttribute(HELPER_KEY, (Object)helper, 1);
        }
        return helper;
    }

    public static ManagementHelper getManagementHelper(HttpSession session) {
        ManagementHelper helper = (ManagementHelper)session.getAttribute(HELPER_KEY);
        if (helper == null) {
            helper = PortletManager.createHelper();
            session.setAttribute(HELPER_KEY, (Object)helper);
        }
        return helper;
    }

    public static J2EEDomain getCurrentDomain(PortletRequest request) {
        J2EEDomain domain = (J2EEDomain)request.getPortletSession(true).getAttribute(DOMAIN_KEY, 1);
        if (domain == null) {
            domain = PortletManager.getManagementHelper(request).getDomains()[0];
            request.getPortletSession().setAttribute(DOMAIN_KEY, (Object)domain, 1);
        }
        return domain;
    }

    public static J2EEServer getCurrentServer(PortletRequest request) {
        J2EEServer server = (J2EEServer)request.getPortletSession(true).getAttribute(SERVER_KEY, 1);
        if (server == null) {
            ManagementHelper helper = PortletManager.getManagementHelper(request);
            server = helper.getServers(PortletManager.getCurrentDomain(request))[0];
            request.getPortletSession().setAttribute(SERVER_KEY, (Object)server, 1);
        }
        return server;
    }

    public static JVM getCurrentJVM(PortletRequest request) {
        JVM jvm = (JVM)request.getPortletSession(true).getAttribute(JVM_KEY, 1);
        if (jvm == null) {
            ManagementHelper helper = PortletManager.getManagementHelper(request);
            jvm = helper.getJavaVMs(PortletManager.getCurrentServer(request))[0];
            request.getPortletSession().setAttribute(JVM_KEY, (Object)jvm, 1);
        }
        return jvm;
    }

    public static String[] getWebManagerNames(PortletRequest request) {
        return PortletManager.getCurrentServer(request).getWebManagers();
    }

    public static WebManager getWebManager(PortletRequest request, String managerObjectName) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        return (WebManager)helper.getObject(managerObjectName);
    }

    public static String[] getWebContainerNames(PortletRequest request, String managerObjectName) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        WebManager manager = (WebManager)helper.getObject(managerObjectName);
        return manager.getContainers();
    }

    public static WebAccessLog getWebAccessLog(PortletRequest request, String managerObjectName, String containerObjectName) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        WebManager manager = (WebManager)helper.getObject(managerObjectName);
        return helper.getWebAccessLog(manager, containerObjectName);
    }

    public static WebContainer getWebContainer(PortletRequest request, String containerObjectName) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        return (WebContainer)helper.getObject(containerObjectName);
    }

    public static WebConnector createWebConnector(PortletRequest request, String managerObjectName, String containerObjectName, String name, String protocol, String host, int port) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        WebManager manager = (WebManager)helper.getObject(managerObjectName);
        String objectName = manager.addConnector(containerObjectName, name, protocol, host, port);
        return (WebConnector)helper.getObject(objectName);
    }

    public static WebConnector[] getWebConnectors(PortletRequest request, String managerObjectName) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        WebManager manager = (WebManager)helper.getObject(managerObjectName);
        return helper.getWebConnectors(manager);
    }

    public static WebConnector[] getWebConnectors(PortletRequest request, String managerObjectName, String protocol) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        WebManager manager = (WebManager)helper.getObject(managerObjectName);
        return helper.getWebConnectors(manager, protocol);
    }

    public static WebConnector[] getWebConnectorsForContainer(PortletRequest request, String managerObjectName, String containerObjectName) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        WebManager manager = (WebManager)helper.getObject(managerObjectName);
        return helper.getWebConnectorsForContainer(manager, containerObjectName);
    }

    public static WebConnector[] getWebConnectorsForContainer(PortletRequest request, String managerObjectName, String containerObjectName, String protocol) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        WebManager manager = (WebManager)helper.getObject(managerObjectName);
        return helper.getWebConnectorsForContainer(manager, containerObjectName, protocol);
    }

    public static EJBManager[] getEJBManagers(PortletRequest request) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        return helper.getEJBManagers(PortletManager.getCurrentServer(request));
    }

    public static EJBManager getEJBManager(PortletRequest request, String managerObjectName) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        return (EJBManager)helper.getObject(managerObjectName);
    }

    public static String[] getJMSManagerNames(PortletRequest request) {
        return PortletManager.getCurrentServer(request).getJMSManagers();
    }

    public static JMSManager getJMSManager(PortletRequest request, String managerObjectName) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        return (JMSManager)helper.getObject(managerObjectName);
    }

    public static String[] getJMSBrokerNames(PortletRequest request, String managerObjectName) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        JMSManager manager = (JMSManager)helper.getObject(managerObjectName);
        return manager.getContainers();
    }

    public static JMSBroker getJMSBroker(PortletRequest request, String brokerObjectName) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        return (JMSBroker)helper.getObject(brokerObjectName);
    }

    public static JMSConnector createJMSConnector(PortletRequest request, String managerObjectName, String containerObjectName, String name, String protocol, String host, int port) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        JMSManager manager = (JMSManager)helper.getObject(managerObjectName);
        String objectName = manager.addConnector(containerObjectName, name, protocol, host, port);
        return (JMSConnector)helper.getObject(objectName);
    }

    public static JMSConnector[] getJMSConnectors(PortletRequest request, String managerObjectName) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        JMSManager manager = (JMSManager)helper.getObject(managerObjectName);
        return helper.getJMSConnectors(manager);
    }

    public static JMSConnector[] getJMSConnectors(PortletRequest request, String managerObjectName, String protocol) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        JMSManager manager = (JMSManager)helper.getObject(managerObjectName);
        return helper.getJMSConnectors(manager, protocol);
    }

    public static JMSConnector[] getJMSConnectorsForContainer(PortletRequest request, String managerObjectName, String brokerObjectName) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        JMSManager manager = (JMSManager)helper.getObject(managerObjectName);
        return helper.getJMSConnectorsForContainer(manager, brokerObjectName);
    }

    public static JMSConnector[] getJMSConnectorsForContainer(PortletRequest request, String managerObjectName, String brokerObjectName, String protocol) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        JMSManager manager = (JMSManager)helper.getObject(managerObjectName);
        return helper.getJMSConnectorsForContainer(manager, brokerObjectName, protocol);
    }

    public static GeronimoExecutor[] getThreadPools(PortletRequest request) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        return helper.getThreadPools(PortletManager.getCurrentServer(request));
    }

    public static String getGBeanDescription(PortletRequest request, String objectName) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        return helper.getGBeanDescription(objectName);
    }

    public static SystemLog getCurrentSystemLog(PortletRequest request) {
        SystemLog log = (SystemLog)request.getPortletSession(true).getAttribute(SYSTEM_LOG_KEY, 1);
        if (log == null) {
            ManagementHelper helper = PortletManager.getManagementHelper(request);
            log = helper.getSystemLog(PortletManager.getCurrentJVM(request));
            request.getPortletSession().setAttribute(SYSTEM_LOG_KEY, (Object)log, 1);
        }
        return log;
    }

    public static GeronimoManagedBean getManagedBean(PortletRequest request, String name) {
        ManagementHelper helper = PortletManager.getManagementHelper(request);
        return (GeronimoManagedBean)helper.getObject(name);
    }
}

