/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.util;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.console.util.RealmHelper;
import org.apache.geronimo.console.util.StringUtils;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;

public class SERealmGroupHelper
extends RealmHelper {
    private static final String GET_GROUPS_FUNCTION = "getGroups";
    private static final String ADD_GROUP_FUNCTION = "addGroupPrincipal";
    private static final String GROUP_EXISTS_FUNCTION = "groupExists";
    private static final String UPDATE_GROUP_FUNCTION = "updateGroupPrincipal";
    private static final String DELETE_GROUP_FUNCTION = "removeGroupPrincipal";
    private static final String GET_USERS_FUNCTION = "getGroupMembers";
    private static final String REFRESH = "refresh";
    private static final String START = "doStart";
    private static final String STOP = "doStop";
    private static final String[] STRING_STRING = new String[]{"java.lang.String", "java.lang.String"};
    private static final String[] STRING = new String[]{"java.lang.String"};
    private static final String[] HASHTABLE = new String[]{"java.util.Hashtable"};
    private static ObjectName mBeanName;
    private static final Kernel kernel;

    public static String[] getGroups() throws Exception {
        String[] groups = (String[])SERealmGroupHelper.invoke(mBeanName, GET_GROUPS_FUNCTION);
        return groups;
    }

    private static void refresh() {
        try {
            kernel.stopGBean(new ObjectName("geronimo.server:name=PropertiesLoginManager,J2EEServer=geronimo,J2EEApplication=null,j2eeType=GBean,J2EEModule=null"));
            kernel.startGBean(new ObjectName("geronimo.server:name=PropertiesLoginManager,J2EEServer=geronimo,J2EEApplication=null,j2eeType=GBean,J2EEModule=null"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addGroup(String groupName, String[] userList) throws Exception {
        SERealmGroupHelper.addGroup(groupName, StringUtils.convertToCommaDelimited(userList));
        SERealmGroupHelper.refresh();
    }

    public static void updateGroup(String groupName, String[] userList) throws Exception {
        SERealmGroupHelper.updateGroup(groupName, StringUtils.convertToCommaDelimited(userList));
        SERealmGroupHelper.refresh();
    }

    public static boolean groupExists(String username) throws Exception {
        Object[] arg = new String[]{username};
        Boolean ret = (Boolean)SERealmGroupHelper.invoke(mBeanName, GROUP_EXISTS_FUNCTION, arg, STRING);
        return ret;
    }

    public static void addGroup(String groupName, String userList) throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("GroupName", groupName);
        props.put("Members", userList);
        Object[] args = new Object[]{props};
        SERealmGroupHelper.invoke(mBeanName, ADD_GROUP_FUNCTION, args, HASHTABLE);
    }

    public static void updateGroup(String groupName, String userList) throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("GroupName", groupName);
        props.put("Members", userList);
        Object[] args = new Object[]{props};
        SERealmGroupHelper.invoke(mBeanName, UPDATE_GROUP_FUNCTION, args, HASHTABLE);
    }

    public static void deleteGroup(String groupName) throws Exception {
        Object[] args = new String[]{groupName};
        SERealmGroupHelper.invoke(mBeanName, DELETE_GROUP_FUNCTION, args, STRING);
        SERealmGroupHelper.refresh();
    }

    public static Set getUsers(String groupName) throws Exception {
        Set ret = null;
        Object[] arg = new String[]{groupName};
        ret = (Set)SERealmGroupHelper.invoke(mBeanName, GET_USERS_FUNCTION, arg, STRING);
        return ret;
    }

    public static boolean isGroupMember(String groupName, String username) throws Exception {
        Collection users = SERealmGroupHelper.getUsersAsCollection(groupName);
        return users.contains(username);
    }

    private static Collection getUsersAsCollection(String groupName) throws Exception {
        return SERealmGroupHelper.getUsers(groupName);
    }

    static {
        kernel = KernelRegistry.getSingleKernel();
        try {
            mBeanName = new ObjectName("geronimo.server:J2EEApplication=org/apache/geronimo/Console,J2EEModule=null,J2EEServer=geronimo,j2eeType=GBean,name=PropertiesLoginManager");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }
}

