/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.util;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.console.util.RealmHelper;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;

public class SERealmUserHelper
extends RealmHelper {
    private static final String GET_USERS_FUNCTION = "getUsers";
    private static final String ADD_USER_FUNCTION = "addUserPrincipal";
    private static final String USER_EXISTS_FUNCTION = "userExists";
    private static final String UPDATE_USER_FUNCTION = "updateUserPrincipal";
    private static final String DELETE_USER_FUNCTION = "removeUserPrincipal";
    private static final String GET_PASSWORD_FUNCTION = "getPassword";
    private static final String REFRESH = "refresh";
    private static final String START = "doStart";
    private static final String STOP = "doStop";
    private static final String[] STRING_STRING = new String[]{"java.lang.String", "java.lang.String"};
    private static final String[] STRING = new String[]{"java.lang.String"};
    private static final String[] HASHTABLE = new String[]{"java.util.Hashtable"};
    private static ObjectName mBeanName;
    private static final Kernel kernel;

    public static String[] getUsers() throws Exception {
        return (String[])SERealmUserHelper.invoke(mBeanName, GET_USERS_FUNCTION);
    }

    private static void refresh() {
        try {
            kernel.stopGBean(new ObjectName("geronimo.server:name=PropertiesLoginManager,J2EEServer=geronimo,J2EEApplication=null,j2eeType=GBean,J2EEModule=null"));
            kernel.startGBean(new ObjectName("geronimo.server:name=PropertiesLoginManager,J2EEServer=geronimo,J2EEApplication=null,j2eeType=GBean,J2EEModule=null"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getPassword(String username) throws Exception {
        Object[] arg = new String[]{username};
        Object ret = SERealmUserHelper.invoke(mBeanName, GET_PASSWORD_FUNCTION, arg, STRING);
        return ret != null ? ret.toString() : "";
    }

    public static boolean userExists(String username) throws Exception {
        Object[] arg = new String[]{username};
        Boolean ret = (Boolean)SERealmUserHelper.invoke(mBeanName, USER_EXISTS_FUNCTION, arg, STRING);
        return ret;
    }

    public static void addUser(String username, String password) throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("UserName", username);
        props.put("Password", password);
        Object[] args = new Object[]{props};
        SERealmUserHelper.invoke(mBeanName, ADD_USER_FUNCTION, args, HASHTABLE);
        SERealmUserHelper.refresh();
    }

    public static void updateUser(String username, String password) throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("UserName", username);
        props.put("Password", password);
        Object[] args = new Object[]{props};
        SERealmUserHelper.invoke(mBeanName, UPDATE_USER_FUNCTION, args, HASHTABLE);
        SERealmUserHelper.refresh();
    }

    public static void deleteUser(String username) throws Exception {
        Object[] args = new String[]{username};
        SERealmUserHelper.invoke(mBeanName, DELETE_USER_FUNCTION, args, STRING);
        SERealmUserHelper.refresh();
    }

    static {
        kernel = KernelRegistry.getSingleKernel();
        try {
            mBeanName = new ObjectName("geronimo.server:J2EEApplication=org/apache/geronimo/Console,J2EEModule=null,J2EEServer=geronimo,j2eeType=GBean,name=PropertiesLoginManager");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }
}

