/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.webmanager;

import java.io.IOException;
import java.util.ArrayList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.BasePortlet;
import org.apache.geronimo.console.util.PortletManager;
import org.apache.geronimo.console.webmanager.ConnectorInfo;
import org.apache.geronimo.kernel.proxy.GeronimoManagedBean;
import org.apache.geronimo.management.geronimo.SecureConnector;
import org.apache.geronimo.management.geronimo.WebConnector;
import org.apache.geronimo.management.geronimo.WebContainer;

public class ConnectorPortlet
extends BasePortlet {
    private static final Log log = LogFactory.getLog((Class)ConnectorPortlet.class);
    private PortletRequestDispatcher normalView;
    private PortletRequestDispatcher maximizedView;
    private PortletRequestDispatcher helpView;
    protected PortletRequestDispatcher editHttpView;
    protected PortletRequestDispatcher editHttpsView;

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String managerName;
        String[] containers;
        String mode = actionRequest.getParameter("mode");
        String[] names = PortletManager.getWebManagerNames((PortletRequest)actionRequest);
        if (names != null && (containers = PortletManager.getWebContainerNames((PortletRequest)actionRequest, managerName = names[0])) != null) {
            String containerName = containers[0];
            WebContainer container = PortletManager.getWebContainer((PortletRequest)actionRequest, containerName);
            String server = ConnectorPortlet.getWebServerType(container.getClass());
            actionResponse.setRenderParameter("server", server);
            if (mode.equals("new")) {
                actionResponse.setRenderParameter("mode", "new");
                String protocol = actionRequest.getParameter("protocol");
                actionResponse.setRenderParameter("protocol", protocol);
            } else if (mode.equals("add")) {
                String protocol = actionRequest.getParameter("protocol");
                String host = actionRequest.getParameter("host");
                int port = Integer.parseInt(actionRequest.getParameter("port"));
                int maxThreads = Integer.parseInt(actionRequest.getParameter("maxThreads"));
                Integer minThreads = this.getInteger(actionRequest, "minThreads");
                String name = actionRequest.getParameter("name");
                WebConnector connector = PortletManager.createWebConnector((PortletRequest)actionRequest, managerName, containerName, name, protocol, host, port);
                connector.setMaxThreads(maxThreads);
                if (server.equals("jetty")) {
                    if (minThreads != null) {
                        ConnectorPortlet.setProperty(connector, "minThreads", minThreads);
                    }
                } else if (server.equals("tomcat")) {
                    // empty if block
                }
                if (protocol.equals("HTTPS")) {
                    String keystoreType = actionRequest.getParameter("keystoreType");
                    String keystoreFile = actionRequest.getParameter("keystoreFile");
                    String privateKeyPass = actionRequest.getParameter("privateKeyPassword");
                    String keystorePass = actionRequest.getParameter("keystorePassword");
                    String secureProtocol = actionRequest.getParameter("secureProtocol");
                    String algorithm = actionRequest.getParameter("algorithm");
                    boolean clientAuth = ConnectorPortlet.isValid(actionRequest.getParameter("clientAuth"));
                    SecureConnector secure = (SecureConnector)connector;
                    if (ConnectorPortlet.isValid(keystoreType)) {
                        secure.setKeystoreType(keystoreType);
                    }
                    if (ConnectorPortlet.isValid(keystoreFile)) {
                        secure.setKeystoreFileName(keystoreFile);
                    }
                    if (ConnectorPortlet.isValid(keystorePass)) {
                        secure.setKeystorePassword(keystorePass);
                    }
                    if (ConnectorPortlet.isValid(secureProtocol)) {
                        secure.setSecureProtocol(secureProtocol);
                    }
                    if (ConnectorPortlet.isValid(algorithm)) {
                        secure.setAlgorithm(algorithm);
                    }
                    secure.setClientAuthRequired(clientAuth);
                    if (server.equals("jetty")) {
                        if (ConnectorPortlet.isValid(privateKeyPass)) {
                            ConnectorPortlet.setProperty(secure, "keyPassword", privateKeyPass);
                        }
                    } else if (server.equals("tomcat")) {
                        // empty if block
                    }
                }
                try {
                    ((GeronimoManagedBean)connector).startRecursive();
                }
                catch (Exception e) {
                    log.error((Object)"Unable to start connector", (Throwable)e);
                }
                actionResponse.setRenderParameter("mode", "list");
            } else if (mode.equals("save")) {
                String host = actionRequest.getParameter("host");
                int port = Integer.parseInt(actionRequest.getParameter("port"));
                int maxThreads = Integer.parseInt(actionRequest.getParameter("maxThreads"));
                Integer minThreads = this.getInteger(actionRequest, "minThreads");
                String objectName = actionRequest.getParameter("objectName");
                WebConnector connector = null;
                WebConnector[] all = PortletManager.getWebConnectors((PortletRequest)actionRequest, managerName);
                for (int i = 0; i < all.length; ++i) {
                    WebConnector conn = all[i];
                    if (!((GeronimoManagedBean)conn).getObjectName().equals(objectName)) continue;
                    connector = conn;
                    break;
                }
                if (connector != null) {
                    connector.setHost(host);
                    connector.setPort(port);
                    connector.setMaxThreads(maxThreads);
                    if (server.equals("jetty")) {
                        if (minThreads != null) {
                            ConnectorPortlet.setProperty(connector, "minThreads", minThreads);
                        } else if (server.equals("tomcat")) {
                            // empty if block
                        }
                    }
                    if (connector instanceof SecureConnector) {
                        String keystoreType = actionRequest.getParameter("keystoreType");
                        String keystoreFile = actionRequest.getParameter("keystoreFile");
                        String privateKeyPass = actionRequest.getParameter("privateKeyPassword");
                        String keystorePass = actionRequest.getParameter("keystorePassword");
                        String secureProtocol = actionRequest.getParameter("secureProtocol");
                        String algorithm = actionRequest.getParameter("algorithm");
                        boolean clientAuth = ConnectorPortlet.isValid(actionRequest.getParameter("clientAuth"));
                        SecureConnector secure = (SecureConnector)connector;
                        if (ConnectorPortlet.isValid(keystoreType)) {
                            secure.setKeystoreType(keystoreType);
                        }
                        if (ConnectorPortlet.isValid(keystoreFile)) {
                            secure.setKeystoreFileName(keystoreFile);
                        }
                        if (ConnectorPortlet.isValid(keystorePass)) {
                            secure.setKeystorePassword(keystorePass);
                        }
                        if (ConnectorPortlet.isValid(secureProtocol)) {
                            secure.setSecureProtocol(secureProtocol);
                        }
                        if (ConnectorPortlet.isValid(algorithm)) {
                            secure.setAlgorithm(algorithm);
                        }
                        secure.setClientAuthRequired(clientAuth);
                        if (server.equals("jetty")) {
                            if (ConnectorPortlet.isValid(privateKeyPass)) {
                                ConnectorPortlet.setProperty(secure, "keyPassword", privateKeyPass);
                            }
                        } else if (server.equals("tomcat")) {
                            // empty if block
                        }
                    }
                }
                actionResponse.setRenderParameter("mode", "list");
            } else if (mode.equals("start")) {
                String objectName = actionRequest.getParameter("name");
                WebConnector connector = null;
                WebConnector[] all = PortletManager.getWebConnectors((PortletRequest)actionRequest, managerName);
                for (int i = 0; i < all.length; ++i) {
                    WebConnector conn = all[i];
                    if (!((GeronimoManagedBean)conn).getObjectName().equals(objectName)) continue;
                    connector = conn;
                    break;
                }
                if (connector != null) {
                    try {
                        ((GeronimoManagedBean)connector).startRecursive();
                    }
                    catch (Exception e) {
                        log.error((Object)"Unable to start connector", (Throwable)e);
                    }
                } else {
                    log.error((Object)"Incorrect connector reference");
                }
                actionResponse.setRenderParameter("name", objectName);
                actionResponse.setRenderParameter("mode", "list");
            } else if (mode.equals("stop")) {
                String objectName = actionRequest.getParameter("name");
                WebConnector connector = null;
                WebConnector[] all = PortletManager.getWebConnectors((PortletRequest)actionRequest, managerName);
                for (int i = 0; i < all.length; ++i) {
                    WebConnector conn = all[i];
                    if (!((GeronimoManagedBean)conn).getObjectName().equals(objectName)) continue;
                    connector = conn;
                    break;
                }
                if (connector != null) {
                    try {
                        ((GeronimoManagedBean)connector).stop();
                    }
                    catch (Exception e) {
                        log.error((Object)"Unable to stop connector", (Throwable)e);
                    }
                } else {
                    log.error((Object)"Incorrect connector reference");
                }
                actionResponse.setRenderParameter("name", objectName);
                actionResponse.setRenderParameter("mode", "list");
            } else if (mode.equals("edit")) {
                String objectName = actionRequest.getParameter("name");
                actionResponse.setRenderParameter("objectName", objectName);
                actionResponse.setRenderParameter("mode", "edit");
            } else if (mode.equals("delete")) {
                String objectName = actionRequest.getParameter("name");
                PortletManager.getWebManager((PortletRequest)actionRequest, managerName).removeConnector(objectName);
                actionResponse.setRenderParameter("mode", "list");
            }
        }
    }

    private Integer getInteger(ActionRequest actionRequest, String key) {
        String value = actionRequest.getParameter(key);
        if (value == null || value.equals("")) {
            return null;
        }
        return new Integer(value);
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        String managerName;
        String[] containers;
        String[] names;
        if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
            return;
        }
        String mode = renderRequest.getParameter("mode");
        if (mode == null || mode.equals("")) {
            mode = "list";
        }
        if ((names = PortletManager.getWebManagerNames((PortletRequest)renderRequest)) != null && (containers = PortletManager.getWebContainerNames((PortletRequest)renderRequest, managerName = names[0])) != null) {
            String containerName = containers[0];
            WebContainer container = PortletManager.getWebContainer((PortletRequest)renderRequest, containerName);
            String server = ConnectorPortlet.getWebServerType(container.getClass());
            renderRequest.setAttribute("server", (Object)server);
            if (mode.equals("new")) {
                String protocol = renderRequest.getParameter("protocol");
                renderRequest.setAttribute("maxThreads", (Object)"50");
                if (server.equals("jetty")) {
                    renderRequest.setAttribute("minThreads", (Object)"10");
                } else if (server.equals("tomcat")) {
                    // empty if block
                }
                renderRequest.setAttribute("protocol", (Object)protocol);
                renderRequest.setAttribute("mode", (Object)"add");
                if (protocol.equals("HTTPS")) {
                    this.editHttpsView.include(renderRequest, renderResponse);
                } else {
                    this.editHttpView.include(renderRequest, renderResponse);
                }
            } else if (mode.equals("edit")) {
                String objectName = renderRequest.getParameter("objectName");
                WebConnector connector = null;
                WebConnector[] all = PortletManager.getWebConnectors((PortletRequest)renderRequest, managerName);
                for (int i = 0; i < all.length; ++i) {
                    WebConnector conn = all[i];
                    if (!((GeronimoManagedBean)conn).getObjectName().equals(objectName)) continue;
                    connector = conn;
                    break;
                }
                if (connector == null) {
                    this.doList(renderRequest, managerName, renderResponse);
                } else {
                    renderRequest.setAttribute("objectName", (Object)objectName);
                    renderRequest.setAttribute("port", (Object)new Integer(connector.getPort()));
                    renderRequest.setAttribute("host", (Object)connector.getHost());
                    int maxThreads = connector.getMaxThreads();
                    renderRequest.setAttribute("maxThreads", (Object)Integer.toString(maxThreads));
                    if (server.equals("jetty")) {
                        int minThreads = ((Number)ConnectorPortlet.getProperty(connector, "minThreads")).intValue();
                        renderRequest.setAttribute("minThreads", (Object)String.valueOf(minThreads));
                    } else if (server.equals("tomcat")) {
                        // empty if block
                    }
                    renderRequest.setAttribute("mode", (Object)"save");
                    if (connector instanceof SecureConnector) {
                        SecureConnector secure = (SecureConnector)connector;
                        renderRequest.setAttribute("keystoreFile", (Object)secure.getKeystoreFileName());
                        renderRequest.setAttribute("keystoreType", (Object)secure.getKeystoreType());
                        renderRequest.setAttribute("algorithm", (Object)secure.getAlgorithm());
                        renderRequest.setAttribute("secureProtocol", (Object)secure.getSecureProtocol());
                        if (secure.isClientAuthRequired()) {
                            renderRequest.setAttribute("clientAuth", (Object)Boolean.TRUE);
                        }
                    }
                    if (connector.getProtocol().equals("HTTPS")) {
                        this.editHttpsView.include(renderRequest, renderResponse);
                    } else {
                        this.editHttpView.include(renderRequest, renderResponse);
                    }
                }
            } else if (mode.equals("list")) {
                this.doList(renderRequest, managerName, renderResponse);
            }
        }
    }

    private void doList(RenderRequest renderRequest, String managerName, RenderResponse renderResponse) throws PortletException, IOException {
        ArrayList<ConnectorInfo> beans = new ArrayList<ConnectorInfo>();
        WebConnector[] connectors = PortletManager.getWebConnectors((PortletRequest)renderRequest, managerName);
        for (int i = 0; i < connectors.length; ++i) {
            WebConnector connector = connectors[i];
            ConnectorInfo info = new ConnectorInfo();
            String objectName = ((GeronimoManagedBean)connector).getObjectName();
            info.setObjectName(objectName);
            info.setDescription(PortletManager.getGBeanDescription((PortletRequest)renderRequest, objectName));
            try {
                ObjectName realName = ObjectName.getInstance(objectName);
                info.setDisplayName(realName.getKeyProperty("name"));
            }
            catch (MalformedObjectNameException e) {
                log.error((Object)"Bad object name for web connector", (Throwable)e);
                info.setDisplayName(info.getDescription());
            }
            info.setState(((GeronimoManagedBean)connector).getState());
            info.setPort(connector.getPort());
            try {
                info.setProtocol(connector.getProtocol());
            }
            catch (IllegalStateException e) {
                info.setProtocol("unknown");
            }
            beans.add(info);
        }
        renderRequest.setAttribute("connectors", beans);
        renderRequest.setAttribute("protocols", (Object)PortletManager.getWebManager((PortletRequest)renderRequest, managerName).getSupportedProtocols());
        if (WindowState.NORMAL.equals((Object)renderRequest.getWindowState())) {
            this.normalView.include(renderRequest, renderResponse);
        } else {
            this.maximizedView.include(renderRequest, renderResponse);
        }
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.helpView.include(renderRequest, renderResponse);
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        PortletContext pc = portletConfig.getPortletContext();
        this.normalView = pc.getRequestDispatcher("/WEB-INF/view/webmanager/connector/normal.jsp");
        this.maximizedView = pc.getRequestDispatcher("/WEB-INF/view/webmanager/connector/maximized.jsp");
        this.helpView = pc.getRequestDispatcher("/WEB-INF/view/webmanager/connector/help.jsp");
        this.editHttpView = pc.getRequestDispatcher("/WEB-INF/view/webmanager/connector/editHTTP.jsp");
        this.editHttpsView = pc.getRequestDispatcher("/WEB-INF/view/webmanager/connector/editHTTPS.jsp");
    }

    public void destroy() {
        this.normalView = null;
        this.maximizedView = null;
        this.helpView = null;
        this.editHttpsView = null;
        this.editHttpView = null;
        super.destroy();
    }

    public static final boolean isValid(String s) {
        return s != null && !s.equals("");
    }
}

