/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.webmanager;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.geronimo.console.BasePortlet;
import org.apache.geronimo.console.util.PortletManager;
import org.apache.geronimo.console.webmanager.JettyStatisticsHelper;
import org.apache.geronimo.management.geronimo.WebContainer;

public class WebManagerPortlet
extends BasePortlet {
    private PortletRequestDispatcher normalView;
    private PortletRequestDispatcher maximizedView;
    private PortletRequestDispatcher helpView;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        try {
            String managerName;
            String[] containers;
            String[] names = PortletManager.getWebManagerNames((PortletRequest)actionRequest);
            if (names == null || (containers = PortletManager.getWebContainerNames((PortletRequest)actionRequest, managerName = names[0])) == null) return;
            String containerName = containers[0];
            WebContainer container = PortletManager.getWebContainer((PortletRequest)actionRequest, containerName);
            String server = WebManagerPortlet.getWebServerType(container.getClass());
            String action = actionRequest.getParameter("stats");
            if (action != null) {
                boolean stats = action.equals("true");
                if (server.equals("jetty")) {
                    WebManagerPortlet.setProperty(container, "collectStatistics", stats ? Boolean.TRUE : Boolean.FALSE);
                } else if (server.equals("tomcat")) {
                    // empty if block
                }
            }
            if (actionRequest.getParameter("resetStats") == null) return;
            if (server.equals("jetty")) {
                WebManagerPortlet.callOperation(container, "resetStatistics", null);
                return;
            }
            if (!server.equals("tomcat")) return;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
            return;
        }
        try {
            String managerName;
            String[] containers;
            String[] names = PortletManager.getWebManagerNames((PortletRequest)renderRequest);
            if (names != null && (containers = PortletManager.getWebContainerNames((PortletRequest)renderRequest, managerName = names[0])) != null) {
                String containerName = containers[0];
                WebContainer container = PortletManager.getWebContainer((PortletRequest)renderRequest, containerName);
                String server = WebManagerPortlet.getWebServerType(container.getClass());
                JettyStatisticsHelper helper = null;
                if (server.equals("jetty")) {
                    helper = new JettyStatisticsHelper();
                } else if (server.equals("tomcat")) {
                    // empty if block
                }
                if (helper != null) {
                    helper.gatherStatistics(container, renderRequest);
                }
            }
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        if (WindowState.NORMAL.equals((Object)renderRequest.getWindowState())) {
            this.normalView.include(renderRequest, renderResponse);
        } else {
            this.maximizedView.include(renderRequest, renderResponse);
        }
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.helpView.include(renderRequest, renderResponse);
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.normalView = portletConfig.getPortletContext().getRequestDispatcher("/WEB-INF/view/webmanager/normal.jsp");
        this.maximizedView = portletConfig.getPortletContext().getRequestDispatcher("/WEB-INF/view/webmanager/maximized.jsp");
        this.helpView = portletConfig.getPortletContext().getRequestDispatcher("/WEB-INF/view/webmanager/help.jsp");
    }

    public void destroy() {
        this.helpView = null;
        this.normalView = null;
        this.maximizedView = null;
        super.destroy();
    }
}

