/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.mavenplugin;

import java.util.ArrayList;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.geronimo.deployment.mavenplugin.AbstractModuleCommand;
import org.apache.geronimo.deployment.mavenplugin.DeploymentClient;

public class UndeployModule
extends AbstractModuleCommand {
    private String id;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void execute() throws Exception {
        DeploymentManager manager = this.getDeploymentManager();
        Target[] targets = manager.getTargets();
        TargetModuleID[] moduleIds = manager.getNonRunningModules(null, targets);
        ArrayList<TargetModuleID> toUndeploy = new ArrayList<TargetModuleID>(moduleIds.length);
        for (int i = 0; i < moduleIds.length; ++i) {
            TargetModuleID moduleId = moduleIds[i];
            if (!this.getId().equals(moduleId.getModuleID())) continue;
            toUndeploy.add(moduleId);
        }
        if (toUndeploy.size() == 0) {
            System.out.println("Module is running or not deployed: " + this.getId());
            return;
        }
        moduleIds = toUndeploy.toArray(new TargetModuleID[toUndeploy.size()]);
        ProgressObject progress = manager.undeploy(moduleIds);
        DeploymentClient.waitFor(progress);
    }
}

