/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.mavenplugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.jelly.JellyContext;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityFilter {
    private File sourceDir;
    private File targetDir;
    private boolean force;
    private Context context;

    public void setSourceDir(String sourceDir) {
        File dir = new File(sourceDir);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("sourceDir is not a directory: " + dir.getAbsolutePath());
        }
        this.sourceDir = dir;
    }

    public void setTargetDir(String targetDir) {
        File dir = new File(targetDir);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalArgumentException("Could not create targetDir: " + dir.getAbsolutePath());
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("targetDir is not a directory: " + dir.getAbsolutePath());
        }
        this.targetDir = dir;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setContext(JellyContext context) {
        this.context = new JellyContextAdapter(context);
    }

    public void execute() throws Exception {
        long processStart = System.currentTimeMillis();
        if (this.sourceDir == null) {
            throw new IllegalStateException("sourceDir was not set");
        }
        if (this.targetDir == null) {
            throw new IllegalStateException("targetDir was not set");
        }
        if (this.context == null) {
            throw new IllegalStateException("context was not set");
        }
        VelocityEngine velocity = new VelocityEngine();
        velocity.setProperty("file.resource.loader.path", (Object)this.sourceDir.getAbsolutePath());
        velocity.init();
        LinkedList plans = new LinkedList();
        VelocityFilter.findPlans(this.sourceDir, plans);
        Iterator iterator = plans.iterator();
        while (iterator.hasNext()) {
            File plan = (File)iterator.next();
            this.processPlan(velocity, plan);
        }
        System.out.println("    Preprocess plans elapse time: " + (System.currentTimeMillis() - processStart) / 1000L + " sec");
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPlan(VelocityEngine velocity, File plan) throws Exception {
        String planName = VelocityFilter.extractPlanName(this.sourceDir, plan);
        Template template = velocity.getTemplate(planName);
        File outputFile = new File(this.targetDir, planName);
        File outputDir = outputFile.getParentFile();
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new IllegalArgumentException("Could not create outputDir: " + outputDir.getAbsolutePath());
        }
        if (!outputDir.isDirectory()) {
            throw new IllegalArgumentException("outputDir is not a directory: " + outputDir.getAbsolutePath());
        }
        if (this.force || outputFile.lastModified() < plan.lastModified()) {
            System.out.println("    Preprocessing " + planName);
            PrintStream out = null;
            Reader templateReader = null;
            try {
                out = new PrintStream(new FileOutputStream(outputFile));
                PrintWriter writer = new PrintWriter(out);
                template.merge(this.context, (Writer)writer);
                writer.flush();
            }
            catch (Throwable throwable) {
                VelocityFilter.close(out);
                VelocityFilter.close(templateReader);
                throw throwable;
            }
            VelocityFilter.close(out);
            VelocityFilter.close(templateReader);
        }
    }

    private static String extractPlanName(File sourceDir, File plan) {
        String sourcePath = sourceDir.getAbsolutePath();
        String planPath = plan.getAbsolutePath();
        if (!planPath.startsWith(sourcePath)) {
            throw new IllegalStateException("Plan is not located in sourceDir: sourceDir=" + sourcePath + " planPath=" + planPath);
        }
        String planName = planPath.substring(sourcePath.length() + 1);
        if (planName.charAt(0) == '\\' || planName.charAt(0) == '/') {
            planName = planName.substring(1);
        }
        return planName;
    }

    private static void findPlans(File dir, Collection resultsFiles) {
        File[] files = dir.listFiles();
        if (null == files) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                VelocityFilter.findPlans(files[i], resultsFiles);
                continue;
            }
            if (!files[i].getName().endsWith(".xml") && !files[i].getName().endsWith(".list") && !files[i].getName().endsWith(".properties")) continue;
            resultsFiles.add(files[i]);
        }
    }

    private static void close(Reader thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void close(OutputStream thing) {
        if (thing != null && thing != System.out) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class JellyContextAdapter
    implements Context {
        private JellyContext jellyContext;
        private HashMap privateContext = new HashMap();

        public JellyContextAdapter(JellyContext jellyContext) {
            this.jellyContext = jellyContext;
        }

        public boolean containsKey(Object key) {
            if (key == null) {
                return false;
            }
            if (this.privateContext.containsKey(key)) {
                return true;
            }
            return this.jellyContext.getVariable(key.toString()) != null;
        }

        public Object get(String key) {
            if (key == null) {
                return null;
            }
            if (this.privateContext.containsKey(key)) {
                return this.privateContext.get(key);
            }
            return this.jellyContext.getVariable(key);
        }

        public Object[] getKeys() {
            HashSet keys = new HashSet(this.jellyContext.getVariables().keySet());
            keys.addAll(this.privateContext.keySet());
            return keys.toArray();
        }

        public Object put(String key, Object value) {
            if (key == null || value == null) {
                return null;
            }
            return this.privateContext.put(key, value);
        }

        public Object remove(Object key) {
            if (key == null) {
                return null;
            }
            return this.privateContext.remove(key);
        }
    }
}

