/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.geronimo.deployment.util.NestedJarFile;
import org.apache.geronimo.deployment.util.UnpackedJarFile;

public final class DeploymentUtil {
    public static final File DUMMY_JAR_FILE;

    private DeploymentUtil() {
    }

    public static File createTempDir() throws IOException {
        File tempDir = File.createTempFile("geronimo-deploymentUtil", ".tmpdir");
        tempDir.delete();
        tempDir.mkdirs();
        return tempDir;
    }

    public static File createTempFile() throws IOException {
        File tempFile = File.createTempFile("geronimo-deploymentUtil", ".tmpdir");
        tempFile.deleteOnExit();
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File destination) throws IOException {
        File destinationDir = destination.getParentFile();
        if (!destinationDir.exists() && !destinationDir.mkdirs()) {
            throw new IOException("Cannot create directory : " + destinationDir);
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(source);
            out = new FileOutputStream(destination);
            DeploymentUtil.writeAll(in, out);
        }
        catch (Throwable throwable) {
            DeploymentUtil.close(in);
            DeploymentUtil.close(out);
            throw throwable;
        }
        DeploymentUtil.close(in);
        DeploymentUtil.close(out);
    }

    private static void writeAll(InputStream in, OutputStream out) throws IOException {
        int count;
        byte[] buffer = new byte[4096];
        while ((count = in.read(buffer)) > 0) {
            out.write(buffer, 0, count);
        }
        out.flush();
    }

    public static File toTempFile(JarFile jarFile, String path) throws IOException {
        return DeploymentUtil.toTempFile(DeploymentUtil.createJarURL(jarFile, path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File toTempFile(URL url) throws IOException {
        File file;
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = url.openStream();
            File tempFile = DeploymentUtil.createTempFile();
            out = new FileOutputStream(tempFile);
            DeploymentUtil.writeAll(in, out);
            file = tempFile;
        }
        catch (Throwable throwable) {
            DeploymentUtil.close(out);
            DeploymentUtil.close(in);
            throw throwable;
        }
        DeploymentUtil.close(out);
        DeploymentUtil.close(in);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAll(URL url) throws IOException {
        String string;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(url.openStream());
            char[] buffer = new char[4000];
            StringBuffer out = new StringBuffer();
            int count = reader.read(buffer);
            while (count >= 0) {
                out.append(buffer, 0, count);
                count = reader.read(buffer);
            }
            string = out.toString();
        }
        catch (Throwable throwable) {
            DeploymentUtil.close(reader);
            throw throwable;
        }
        DeploymentUtil.close(reader);
        return string;
    }

    public static File toFile(JarFile jarFile) throws IOException {
        if (jarFile instanceof UnpackedJarFile) {
            return ((UnpackedJarFile)jarFile).getBaseDir();
        }
        throw new IOException("jarFile is not a directory");
    }

    public static File toFile(JarFile jarFile, String path) throws IOException {
        if (jarFile instanceof UnpackedJarFile) {
            File baseDir = ((UnpackedJarFile)jarFile).getBaseDir();
            File file = new File(baseDir, path);
            if (!file.isFile()) {
                throw new IOException("No such file: " + file.getAbsolutePath());
            }
            return file;
        }
        String urlString = "jar:" + new File(jarFile.getName()).toURL() + "!/" + path;
        return DeploymentUtil.toTempFile(new URL(urlString));
    }

    public static URL createJarURL(JarFile jarFile, String path) throws MalformedURLException {
        NestedJarFile nestedJar;
        if (jarFile instanceof NestedJarFile && (nestedJar = (NestedJarFile)jarFile).isUnpacked()) {
            JarFile baseJar = nestedJar.getBaseJar();
            String basePath = nestedJar.getBasePath();
            if (baseJar instanceof UnpackedJarFile) {
                File baseDir = ((UnpackedJarFile)baseJar).getBaseDir();
                baseDir = new File(baseDir, basePath);
                return new File(baseDir, path).toURL();
            }
        }
        if (jarFile instanceof UnpackedJarFile) {
            File baseDir = ((UnpackedJarFile)jarFile).getBaseDir();
            return new File(baseDir, path).toURL();
        }
        String urlString = "jar:" + new File(jarFile.getName()).toURL() + "!/" + path;
        return new URL(urlString);
    }

    public static JarFile createJarFile(File jarFile) throws IOException {
        if (jarFile.isDirectory()) {
            return new UnpackedJarFile(jarFile);
        }
        return new JarFile(jarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyToPackedJar(JarFile inputJar, File outputFile) throws IOException {
        if (inputJar.getClass() == JarFile.class) {
            DeploymentUtil.copyFile(new File(inputJar.getName()), outputFile);
            return;
        }
        if (inputJar instanceof NestedJarFile && ((NestedJarFile)inputJar).isPacked()) {
            NestedJarFile nestedJarFile = (NestedJarFile)inputJar;
            JarFile baseJar = nestedJarFile.getBaseJar();
            String basePath = nestedJarFile.getBasePath();
            if (baseJar instanceof UnpackedJarFile) {
                DeploymentUtil.copyFile(((UnpackedJarFile)baseJar).getFile(basePath), outputFile);
                return;
            }
            DeploymentUtil.copyFile(new File(baseJar.getName()), outputFile);
            return;
        }
        JarOutputStream out = null;
        try {
            out = new JarOutputStream(new FileOutputStream(outputFile));
            byte[] buffer = new byte[4096];
            Enumeration<JarEntry> entries = inputJar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream in = inputJar.getInputStream(entry);
                try {
                    out.putNextEntry(new ZipEntry(entry.getName()));
                    try {
                        int count;
                        while ((count = in.read(buffer)) > 0) {
                            out.write(buffer, 0, count);
                        }
                    }
                    finally {
                        out.closeEntry();
                    }
                }
                finally {
                    DeploymentUtil.close(in);
                }
            }
        }
        catch (Throwable throwable) {
            DeploymentUtil.close(out);
            throw throwable;
        }
        DeploymentUtil.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jarDirectory(File sourceDirecotry, File destinationFile) throws IOException {
        UnpackedJarFile inputJar = new UnpackedJarFile(sourceDirecotry);
        try {
            DeploymentUtil.copyToPackedJar(inputJar, destinationFile);
        }
        finally {
            DeploymentUtil.close(inputJar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unzipToDirectory(ZipFile zipFile, File destDir) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        block5: while (true) {
            while (entries.hasMoreElements()) {
                InputStream in;
                block9: {
                    Object var8_8;
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) {
                        File dir = new File(destDir, entry.getName());
                        boolean success = dir.mkdirs();
                        if (success) continue;
                        throw new IOException("Cannot create directory " + dir.getAbsolutePath());
                    }
                    File file = new File(destDir, entry.getName());
                    BufferedOutputStream out = null;
                    in = null;
                    try {
                        out = new BufferedOutputStream(new FileOutputStream(file));
                        in = zipFile.getInputStream(entry);
                        DeploymentUtil.writeAll(in, out);
                        var8_8 = null;
                        if (null == out) break block9;
                    }
                    catch (Throwable throwable) {
                        var8_8 = null;
                        if (null != out) {
                            ((OutputStream)out).close();
                        }
                        if (null == in) throw throwable;
                        in.close();
                        throw throwable;
                        return;
                    }
                    ((OutputStream)out).close();
                }
                if (null == in) continue block5;
                in.close();
                {
                    continue block5;
                }
            }
        }
        finally {
            zipFile.close();
        }
    }

    public static boolean recursiveDelete(File root, Collection unableToDeleteCollection) {
        File[] files;
        if (root == null) {
            return true;
        }
        if (root.isDirectory() && (files = root.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    DeploymentUtil.recursiveDelete(file);
                    continue;
                }
                if (file.delete() || unableToDeleteCollection == null) continue;
                unableToDeleteCollection.add(file);
            }
        }
        return root.delete();
    }

    public static boolean recursiveDelete(File root) {
        return DeploymentUtil.recursiveDelete(root, null);
    }

    public static Collection listRecursiveFiles(File file) {
        LinkedList list = new LinkedList();
        DeploymentUtil.listRecursiveFiles(file, list);
        return Collections.unmodifiableCollection(list);
    }

    public static void listRecursiveFiles(File file, Collection collection) {
        File[] files = file.listFiles();
        if (null == files) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            collection.add(files[i]);
            if (!files[i].isDirectory()) continue;
            DeploymentUtil.listRecursiveFiles(files[i], collection);
        }
    }

    public static void flush(OutputStream thing) {
        if (thing != null) {
            try {
                thing.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void flush(Writer thing) {
        if (thing != null) {
            try {
                thing.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(JarFile thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(InputStream thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Reader thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Writer thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        try {
            DUMMY_JAR_FILE = DeploymentUtil.createTempFile();
            new JarOutputStream((OutputStream)new FileOutputStream(DUMMY_JAR_FILE), new Manifest()).close();
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static final class EmptyInputStream
    extends InputStream {
        public int read() {
            return -1;
        }

        public int read(byte[] b) {
            return -1;
        }

        public int read(byte[] b, int off, int len) {
            return -1;
        }

        public long skip(long n) {
            return 0L;
        }

        public int available() {
            return 0;
        }

        public void close() {
        }

        public synchronized void mark(int readlimit) {
        }

        public synchronized void reset() {
        }

        public boolean markSupported() {
            return false;
        }
    }
}

