/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.util.NestedJarEntry;
import org.apache.geronimo.deployment.util.UnpackedJarEntry;

public class NestedJarFile
extends JarFile {
    private JarFile baseJar;
    private String basePath;
    private boolean isClosed = false;
    private boolean manifestLoaded = false;
    private Manifest manifest;
    private File tempFile;

    public NestedJarFile(JarFile jarFile, String path) throws IOException {
        super(DeploymentUtil.DUMMY_JAR_FILE);
        JarEntry targetEntry = jarFile.getJarEntry(path + "/");
        if (targetEntry == null && (targetEntry = jarFile.getJarEntry(path)) == null) {
            throw new IOException("Jar entry does not exist: jarFile=" + jarFile.getName() + ", path=" + path);
        }
        if (targetEntry.isDirectory()) {
            this.baseJar = jarFile;
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            this.basePath = path;
        } else if (targetEntry instanceof UnpackedJarEntry) {
            File targetFile = ((UnpackedJarEntry)targetEntry).getFile();
            this.baseJar = new JarFile(targetFile);
            this.basePath = "";
        } else {
            this.tempFile = DeploymentUtil.toFile(jarFile, targetEntry.getName());
            this.baseJar = new JarFile(this.tempFile);
            this.basePath = "";
        }
    }

    public boolean isUnpacked() {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        return this.basePath.length() > 0;
    }

    public boolean isPacked() {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        return this.basePath.length() == 0;
    }

    public JarFile getBaseJar() {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        return this.baseJar;
    }

    public String getBasePath() {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        return this.basePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Manifest getManifest() throws IOException {
        block7: {
            if (this.isClosed) {
                throw new IllegalStateException("NestedJarFile is closed");
            }
            if (this.manifestLoaded) return this.manifest;
            JarEntry manifestEntry = this.getBaseEntry("META-INF/MANIFEST.MF");
            if (manifestEntry != null && !manifestEntry.isDirectory()) {
                InputStream in = null;
                try {
                    in = this.baseJar.getInputStream(manifestEntry);
                    this.manifest = new Manifest(in);
                    Object var4_3 = null;
                    if (in == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException e) {}
                in.close();
            }
        }
        this.manifestLoaded = true;
        return this.manifest;
    }

    public NestedJarEntry getNestedJarEntry(String name) {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        JarEntry baseEntry = this.getBaseEntry(name);
        if (baseEntry == null) {
            return null;
        }
        return new NestedJarEntry(name, baseEntry, this.getManifestSafe());
    }

    public JarEntry getJarEntry(String name) {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        return this.getNestedJarEntry(name);
    }

    public ZipEntry getEntry(String name) {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        return this.getNestedJarEntry(name);
    }

    public Enumeration entries() {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        ArrayList<JarEntry> baseEntries = Collections.list(this.baseJar.entries());
        LinkedList<NestedJarEntry> entries = new LinkedList<NestedJarEntry>();
        Iterator iterator = baseEntries.iterator();
        while (iterator.hasNext()) {
            JarEntry baseEntry = (JarEntry)iterator.next();
            String path = baseEntry.getName();
            if (!path.startsWith(this.basePath)) continue;
            entries.add(new NestedJarEntry(path.substring(this.basePath.length()), baseEntry, this.getManifestSafe()));
        }
        return Collections.enumeration(entries);
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        JarEntry baseEntry = zipEntry instanceof NestedJarEntry ? ((NestedJarEntry)zipEntry).getBaseEntry() : this.getBaseEntry(zipEntry.getName());
        if (baseEntry == null) {
            throw new IOException("Entry not found: name=" + baseEntry.getName());
        }
        if (baseEntry.isDirectory()) {
            return new DeploymentUtil.EmptyInputStream();
        }
        return this.baseJar.getInputStream(baseEntry);
    }

    public String getName() {
        return this.baseJar.getName();
    }

    public int size() {
        if (this.isClosed) {
            throw new IllegalStateException("NestedJarFile is closed");
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block5: {
            if (this.isClosed) {
                return;
            }
            try {
                if (this.baseJar != null && this.isPacked()) {
                    this.baseJar.close();
                }
                Object var2_1 = null;
                this.isClosed = true;
                this.baseJar = null;
                this.basePath = null;
                this.manifestLoaded = false;
                this.manifest = null;
                if (this.tempFile == null) break block5;
                this.tempFile.delete();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.isClosed = true;
                this.baseJar = null;
                this.basePath = null;
                this.manifestLoaded = false;
                this.manifest = null;
                if (this.tempFile != null) {
                    this.tempFile.delete();
                    this.tempFile = null;
                }
                throw throwable;
            }
            this.tempFile = null;
            {
            }
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private JarEntry getBaseEntry(String name) {
        return this.baseJar.getJarEntry(this.basePath + name);
    }

    private Manifest getManifestSafe() {
        Manifest manifest = null;
        try {
            manifest = this.getManifest();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return manifest;
    }
}

