/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.logging.log4j;

import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBean;
import org.apache.geronimo.gbean.GBeanContext;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GConstructorInfo;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.kernel.log.GeronimoLogFactory;
import org.apache.geronimo.system.logging.log4j.CachingLog4jLog;
import org.apache.geronimo.system.logging.log4j.URLConfigurator;
import org.apache.geronimo.system.logging.log4j.XLevel;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Log4jService
implements GBean {
    private URL configURL;
    private int refreshPeriod;
    private ServerInfo serverInfo;
    private Timer timer = new Timer(true);
    private TimerTask monitor;
    private long lastChanged = -1L;
    public static final GBeanInfo GBEAN_INFO;

    public Log4jService(URL configURL, int refreshPeroid, ServerInfo serverInfo) {
        this.setRefreshPeriod(refreshPeroid);
        this.setConfigurationURL(configURL);
        this.serverInfo = serverInfo;
        LogFactory logFactory = LogFactory.getFactory();
        if (!(logFactory instanceof GeronimoLogFactory)) {
            throw new IllegalStateException("Commons log factory is not a GeronimoLogFactory");
        }
    }

    public String getLoggerLevel(String logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        Level level = Logger.getLogger((String)logger).getLevel();
        if (level != null) {
            return level.toString();
        }
        return null;
    }

    public void setLoggerLevel(String logger, String level) {
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        if (level == null) {
            throw new IllegalArgumentException("level is null");
        }
        Logger.getLogger((String)logger).setLevel(XLevel.toLevel(level));
    }

    public synchronized int getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public synchronized void setRefreshPeriod(int period) {
        if (period < 1) {
            throw new IllegalArgumentException("Refresh period must be > 0");
        }
        if (this.refreshPeriod != period) {
            this.refreshPeriod = period;
            this.schedule();
        }
    }

    public synchronized URL getConfigurationURL() {
        return this.configURL;
    }

    public synchronized void setConfigurationURL(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        this.configURL = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigure() {
        URL url;
        Log4jService log4jService = this;
        synchronized (log4jService) {
            url = this.configURL;
        }
        URLConfigurator.configure(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule() {
        if (this.timer != null) {
            TimerTask task;
            Log4jService log4jService = this;
            synchronized (log4jService) {
                if (this.monitor != null) {
                    this.monitor.cancel();
                }
                task = this.monitor = new URLMonitorTask();
                this.timer.schedule(this.monitor, 1000 * this.refreshPeriod, (long)(1000 * this.refreshPeriod));
            }
            task.run();
        }
    }

    public void setGBeanContext(GBeanContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() {
        GeronimoLogFactory logFactory;
        this.schedule();
        Logger.getRootLogger();
        GeronimoLogFactory geronimoLogFactory = logFactory = (GeronimoLogFactory)LogFactory.getFactory();
        synchronized (geronimoLogFactory) {
            if (!(logFactory.getLogFactory() instanceof CachingLog4jLogFactory)) {
                logFactory.setLogFactory((LogFactory)new CachingLog4jLogFactory());
            }
        }
    }

    public synchronized void doStop() {
        if (this.monitor != null) {
            this.monitor.cancel();
            this.monitor = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void doFail() {
        this.doStop();
    }

    private synchronized URL resolveURL() {
        try {
            URI configURI = null;
            URI baseURI = new URI(this.serverInfo.getBaseDirectory());
            return baseURI.resolve(configURI).toURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(Log4jService.class.getName());
        infoFactory.setConstructor(new GConstructorInfo(new String[]{"ConfigurationURL", "RefreshPeriod", "ServerInfo"}, new Class[]{URL.class, Integer.TYPE, ServerInfo.class}));
        infoFactory.addAttribute(new GAttributeInfo("ConfigurationURL", true));
        infoFactory.addAttribute(new GAttributeInfo("RefreshPeriod", true));
        infoFactory.addReference(new GReferenceInfo("ServerInfo", ServerInfo.class.getName()));
        infoFactory.addOperation(new GOperationInfo("reconfigure"));
        infoFactory.addOperation(new GOperationInfo("setLoggerLevel", new String[]{String.class.getName(), String.class.getName()}));
        infoFactory.addOperation(new GOperationInfo("getLoggerLevel", new String[]{String.class.getName()}));
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private static class CachingLog4jLogFactory
    extends LogFactory {
        private CachingLog4jLogFactory() {
        }

        public Log getInstance(Class clazz) throws LogConfigurationException {
            return this.getInstance(clazz.getName());
        }

        public Log getInstance(String name) throws LogConfigurationException {
            return new CachingLog4jLog(name);
        }

        public Object getAttribute(String name) {
            return null;
        }

        public String[] getAttributeNames() {
            return new String[0];
        }

        public void release() {
        }

        public void removeAttribute(String name) {
        }

        public void setAttribute(String name, Object value) {
        }
    }

    private class URLMonitorTask
    extends TimerTask {
        private URLMonitorTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                long lastModified;
                URLMonitorTask uRLMonitorTask = this;
                synchronized (uRLMonitorTask) {
                    URLConnection connection = Log4jService.this.resolveURL().openConnection();
                    lastModified = connection.getLastModified();
                }
                if (Log4jService.this.lastChanged < lastModified) {
                    Log4jService.this.lastChanged = lastModified;
                    Log4jService.this.reconfigure();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

