/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.log.GeronimoLogging;
import org.apache.geronimo.system.url.GeronimoURLFactory;

public class Daemon {
    private Daemon() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            ArrayList<URI> configs = new ArrayList<URI>();
            for (int i = 0; i < args.length; ++i) {
                try {
                    configs.add(new URI(args[i]));
                    continue;
                }
                catch (URISyntaxException e) {
                    System.err.println("Invalid configuration-id: " + args[i]);
                    e.printStackTrace();
                    System.exit(1);
                    throw new AssertionError();
                }
            }
            ClassLoader classLoader = Daemon.class.getClassLoader();
            GBeanMBean configuration = new GBeanMBean(Configuration.GBEAN_INFO);
            ObjectInputStream ois = new ObjectInputStream(classLoader.getResourceAsStream("META-INF/config.ser"));
            try {
                Configuration.loadGMBeanState((GBeanMBean)configuration, (ObjectInputStream)ois);
            }
            finally {
                ois.close();
            }
            final Kernel kernel = new Kernel("geronimo.kernel", "geronimo");
            try {
                kernel.boot();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(2);
            }
            ConfigurationManager configurationManager = kernel.getConfigurationManager();
            final ObjectName configName = configurationManager.load(configuration, classLoader.getResource("/"));
            Runtime.getRuntime().addShutdownHook(new Thread("Shutdown Thread"){

                public void run() {
                    if (kernel.isRunning()) {
                        try {
                            kernel.stopGBean(configName);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        kernel.shutdown();
                    }
                }
            });
            kernel.startRecursiveGBean(configName);
            try {
                Iterator i = configs.iterator();
                while (i.hasNext()) {
                    URI configID = (URI)i.next();
                    List list = configurationManager.loadRecursive(configID);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ObjectName name = (ObjectName)iterator.next();
                        kernel.startRecursiveGBean(name);
                    }
                }
            }
            catch (Exception e) {
                kernel.shutdown();
                e.printStackTrace();
                System.exit(3);
            }
            while (kernel.isRunning()) {
                try {
                    Kernel e = kernel;
                    synchronized (e) {
                        kernel.wait();
                    }
                }
                catch (InterruptedException e) {
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(3);
            throw new AssertionError();
        }
    }

    static {
        GeronimoLogging.initialize((GeronimoLogging)GeronimoLogging.INFO);
        GeronimoURLFactory.install();
    }
}

