/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.timer.vm;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.geronimo.timer.PersistenceException;
import org.apache.geronimo.timer.Playback;
import org.apache.geronimo.timer.WorkInfo;
import org.apache.geronimo.timer.WorkerPersistence;

public class VMWorkerPersistence
implements WorkerPersistence {
    private final Map tasks = Collections.synchronizedMap(new LinkedHashMap());
    private final SynchronizedLong counter = new SynchronizedLong(0L);

    public void save(WorkInfo workInfo) throws PersistenceException {
        long id = this.counter.increment();
        workInfo.setId(id);
        this.tasks.put(new Long(id), workInfo);
    }

    public void cancel(long id) throws PersistenceException {
        this.tasks.remove(new Long(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playback(String key, Playback playback) throws PersistenceException {
        Map map = this.tasks;
        synchronized (map) {
            Iterator iterator = this.tasks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                WorkInfo workInfo = (WorkInfo)entry.getValue();
                playback.schedule(workInfo);
            }
        }
    }

    public void fixedRateWorkPerformed(long id) throws PersistenceException {
    }

    public void intervalWorkPerformed(long id, long period) throws PersistenceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getIdsByKey(String key, Object userId) throws PersistenceException {
        ArrayList<Long> ids = new ArrayList<Long>();
        Map map = this.tasks;
        synchronized (map) {
            Iterator iterator = this.tasks.values().iterator();
            while (iterator.hasNext()) {
                WorkInfo workInfo = (WorkInfo)iterator.next();
                if (!key.equals(workInfo.getKey()) || userId != null && !userId.equals(workInfo.getUserId())) continue;
                ids.add(new Long(workInfo.getId()));
            }
        }
        return ids;
    }
}

