/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.timer;

import java.util.Date;
import org.apache.geronimo.timer.ExecutorFeedingTimerTask;
import org.apache.geronimo.timer.ExecutorTask;

public class WorkInfo {
    private long id = -1L;
    private final String key;
    private final Object userId;
    private final Object userInfo;
    private Date time;
    private final Long period;
    private final boolean atFixedRate;
    private ExecutorFeedingTimerTask worker;
    private ExecutorTask taskWrapper;
    private Object clientHandle;

    public WorkInfo(String key, Object userId, Object userInfo, Date time, Long period, boolean atFixedRate) {
        this.key = key;
        this.userId = userId;
        this.userInfo = userInfo;
        this.time = time;
        this.period = period;
        this.atFixedRate = atFixedRate;
    }

    public String getKey() {
        return this.key;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        if (this.id != -1L) {
            throw new IllegalStateException("Id can be set only once!");
        }
        this.id = id;
    }

    public Object getUserId() {
        return this.userId;
    }

    public Object getUserInfo() {
        return this.userInfo;
    }

    public Date getTime() {
        return this.time;
    }

    public Long getPeriod() {
        return this.period;
    }

    public boolean getAtFixedRate() {
        return this.atFixedRate;
    }

    public void initialize(ExecutorFeedingTimerTask worker, ExecutorTask taskWrapper) {
        this.worker = worker;
        this.taskWrapper = taskWrapper;
    }

    public ExecutorFeedingTimerTask getExecutorFeedingTimerTask() {
        return this.worker;
    }

    public Runnable getExecutorTask() {
        return this.taskWrapper;
    }

    public Object getClientHandle() {
        return this.clientHandle;
    }

    public void setClientHandle(Object clientHandle) {
        this.clientHandle = clientHandle;
    }

    public boolean isOneTime() {
        return this.period == null;
    }

    void nextTime() {
        if (this.period == null) {
            throw new IllegalStateException("This is a one-time timerTask");
        }
        this.time = new Date(this.time.getTime() + this.period);
    }

    public void nextInterval() {
        if (this.period == null) {
            throw new IllegalStateException("This is a one-time timerTask");
        }
        this.time = new Date(System.currentTimeMillis() + this.period);
    }
}

